/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.junit.Test;

public class IgniteCacheSqlInsertValidationSelfTest
extends AbstractIndexingCommonTest {
    private static final String TEST_CLASS_NAME = "MyClass";
    private static IgniteCache<Object, Object> cache;
    private static final Long DEFAULT_FK2_VAL;
    private static final Long DEFAULT_FK1_VAL;
    private static boolean oldAllowColumnsVal;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        this.startGrid(0);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)oldAllowColumnsVal);
        super.afterTestsStopped();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        HashMap<String, Long> defsFK2 = new HashMap<String, Long>();
        defsFK2.put("fk2", DEFAULT_FK2_VAL);
        cache = this.jcache((Ignite)this.grid(0), IgniteCacheSqlInsertValidationSelfTest.defaultCacheConfiguration().setName("testCache").setQueryEntities(Arrays.asList(new QueryEntity(Key.class.getName(), Val.class.getName()).addQueryField("fk1", "java.lang.Long", null).addQueryField("fk2", "java.lang.Long", null).addQueryField("fv1", "java.lang.Long", null).addQueryField("fv2", "java.lang.Long", null).setTableName("FORGOTTEN_KEY_FLDS"), new QueryEntity(Key.class.getName(), Integer.class.getName()).addQueryField("fk1", "java.lang.Long", null).addQueryField("fk2", "java.lang.Long", null).setDefaultFieldValues(defsFK2).setKeyFields(new HashSet<String>(Arrays.asList("fk1", "fk2"))).setTableName("WITH_KEY_FLDS"), new QueryEntity(Integer.class.getName(), Val2.class.getName()).addQueryField("fv1", "java.lang.Long", null).addQueryField("fv2", "java.lang.Long", null).setTableName("INT_KEY_TAB"), new QueryEntity(SuperKey.class, String.class).setTableName("SUPER_TAB"), new QueryEntity(String.class.getName(), TEST_CLASS_NAME).setTableName("MY_CLASS"))), "testCache");
    }

    protected void afterTest() throws Exception {
        if (cache != null) {
            cache.destroy();
        }
    }

    @Test
    public void testCacheApiIsStillAllowed() {
        cache.put((Object)new Key(1L, 2L), (Object)new Val(3L, 4L));
        IgniteCacheSqlInsertValidationSelfTest.assertNotNull((String)"Expected cache to contain object ", (Object)cache.get((Object)new Key(1L, 2L)));
    }

    @Test
    public void testInsertDefaultKeyName() {
        Object cnt = this.execute("INSERT INTO INT_KEY_TAB (_key, fv1, fv2) VALUES (1 , 2 , 3)", new Object[0]).get(0).get(0);
        IgniteCacheSqlInsertValidationSelfTest.assertEquals((String)"Expected one row successfully inserted ", (Object)1L, cnt);
    }

    @Test
    public void testIncorrectComplex() {
        this.execute("INSERT INTO FORGOTTEN_KEY_FLDS(FK1, FK2, FV1, FV2) VALUES (2,3,4,5)", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.execute("INSERT INTO FORGOTTEN_KEY_FLDS(FK1, FK2, FV1, FV2) VALUES (8,9,10,11)", new Object[0]), TransactionDuplicateKeyException.class, (String)"Duplicate key during INSERT");
    }

    @Test
    public void testNotAllKeyColsComplex() {
        this.execute("INSERT INTO WITH_KEY_FLDS(FK1, _val) VALUES (7, 1)", new Object[0]);
        this.execute("INSERT INTO WITH_KEY_FLDS(FK2, _val) VALUES (15, 2)", new Object[0]);
        Long fk2 = (Long)this.execute("SELECT FK2 FROM WITH_KEY_FLDS WHERE _val = 1", new Object[0]).get(0).get(0);
        Long fk1 = (Long)this.execute("SELECT FK1 FROM WITH_KEY_FLDS WHERE _val = 2", new Object[0]).get(0).get(0);
        IgniteCacheSqlInsertValidationSelfTest.assertEquals((Object)DEFAULT_FK2_VAL, (Object)fk2);
        IgniteCacheSqlInsertValidationSelfTest.assertEquals((Object)DEFAULT_FK1_VAL, (Object)fk1);
    }

    @Test
    public void testMixedPlaceholderWithOtherKeyFields() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.execute("INSERT INTO WITH_KEY_FLDS(_key, FK1, _val) VALUES (?, ?, ?)", new Key(1L, 2L), 42, 43), IgniteSQLException.class, (String)"Column _KEY refers to entire key cache object.");
    }

    @Test
    public void testSuperKey() {
        this.execute("INSERT INTO SUPER_TAB (SUPERKEYID, NESTEDKEY, _val) VALUES (?, ?, ?)", 123, new NestedKey("the name "), "the _val value");
    }

    @Test
    public void testSuperKeyNative() {
        this.execute("INSERT INTO SUPER_TAB (_key, _val) VALUES (?, ?)", new SuperKey(1L, new NestedKey("the name")), "_val value");
    }

    @Test
    public void testInsertImplicitAllFields() {
        this.execute("CREATE TABLE PUBLIC.IMPLICIT_INS (id1 BIGINT, id2 BIGINT, val BIGINT, PRIMARY KEY(id1, id2))", new Object[0]);
        this.execute("INSERT INTO PUBLIC.IMPLICIT_INS VALUES (1,2,3)", new Object[0]);
    }

    @Test
    public void testValidationOfCompoundKey() {
        this.execute("CREATE TABLE PUBLIC.TBL (id1 BIGINT, id2 BIGINT NOT NULL, val BIGINT, PRIMARY KEY(id1, id2))", new Object[0]);
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.execute("INSERT INTO PUBLIC.TBL VALUES (1, null, 3)", new Object[0]), IgniteSQLException.class, (String)"Null value is not allowed for column 'ID2'");
    }

    @Test
    public void testValidationSkippedForRawKeyVal() {
        String key = "foo";
        BinaryObject bo = this.grid(0).binary().builder(TEST_CLASS_NAME).setField(key, (Object)"bar").build();
        IgniteCache binCache = cache.withKeepBinary();
        binCache.put((Object)key, (Object)bo);
        List res = binCache.query(new SqlFieldsQuery("SELECT _val FROM MY_CLASS WHERE _key = ?").setArgs(new Object[]{key})).getAll();
        IgniteCacheSqlInsertValidationSelfTest.assertEquals((int)1, (int)res.size());
        IgniteCacheSqlInsertValidationSelfTest.assertEquals((int)1, (int)((List)res.get(0)).size());
        IgniteCacheSqlInsertValidationSelfTest.assertTrue((boolean)(((List)res.get(0)).get(0) instanceof BinaryObject));
        IgniteCacheSqlInsertValidationSelfTest.assertEquals((String)((String)bo.field(key)), (String)((String)((BinaryObject)((List)res.get(0)).get(0)).field(key)));
    }

    private List<List<?>> execute(String sql, Object ... args) {
        return cache.query(new SqlFieldsQuery(sql).setArgs(args)).getAll();
    }

    protected CacheConfiguration cacheConfiguration(QueryEntity qryEntity) {
        CacheConfiguration cache = IgniteCacheSqlInsertValidationSelfTest.defaultCacheConfiguration();
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setQueryEntities(Collections.singletonList(qryEntity));
        return cache;
    }

    static {
        DEFAULT_FK2_VAL = 42L;
        DEFAULT_FK1_VAL = null;
    }

    private static class Val2 {
        private long fv1;
        private long fv2;

        public Val2(long fv1, long fv2) {
            this.fv1 = fv1;
            this.fv2 = fv2;
        }
    }

    private static class Val {
        private long fv1;
        private long fv2;

        public Val(long fv1, long fv2) {
            this.fv1 = fv1;
            this.fv2 = fv2;
        }
    }

    private static class NestedKey {
        @QuerySqlField
        private String name;

        public NestedKey(String name) {
            this.name = name;
        }
    }

    private static class SuperKey {
        @QuerySqlField
        private long superKeyId;
        @QuerySqlField
        private NestedKey nestedKey;

        public SuperKey(long superKeyId, NestedKey nestedKey) {
            this.superKeyId = superKeyId;
            this.nestedKey = nestedKey;
        }
    }

    private static class Key {
        private long fk1;
        private long fk2;

        public Key(long fk1, long fk2) {
            this.fk1 = fk1;
            this.fk2 = fk2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.fk1 == key.fk1 && this.fk2 == key.fk2;
        }

        public int hashCode() {
            return Objects.hash(this.fk1, this.fk2);
        }
    }
}

