/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Before;
import org.junit.Test;

public class IgniteCacheSqlDmlErrorSelfTest
extends AbstractIndexingCommonTest {
    private static IgniteCache<?, ?> cache;
    private static boolean oldAllowColumnsVal;

    public void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        this.startGrids(1);
        cache = this.grid(0).createCache("default");
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)oldAllowColumnsVal);
        super.afterTestsStopped();
    }

    @Before
    public void dropAdnCreateTables() {
        IgniteCacheSqlDmlErrorSelfTest.execute("DROP TABLE IF EXISTS COMPOSITE;", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("DROP TABLE IF EXISTS SIMPLE", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("DROP TABLE IF EXISTS SIMPLE_WRAPPED", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("CREATE TABLE COMPOSITE (id1 INT, id2 INT, name1 VARCHAR, name2 VARCHAR, PRIMARY KEY(id1, id2)) WITH \"key_type=" + CompositeKey.class.getName() + ", value_type=" + CompositeValue.class.getName() + "\"", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("CREATE TABLE SIMPLE (id INT PRIMARY KEY, name VARCHAR) WITH \"wrap_value=false, wrap_key=false\"", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("CREATE TABLE SIMPLE_WRAPPED (id INT PRIMARY KEY, name VARCHAR) WITH \"wrap_value=true, wrap_key=true\"", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO COMPOSITE (_key, _val) VALUES (?, ?)", new CompositeKey(), new CompositeValue());
        IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE VALUES (146, 'default name')", new Object[0]);
        IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE_WRAPPED VALUES (147, 'default name')", new Object[0]);
    }

    @Test
    public void testCopyFromIsNotSupported() {
        String path = IgniteUtils.resolveIgnitePath((String)"/modules/indexing/src/test/resources/bulkload_ok.csv").getAbsolutePath();
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> IgniteCacheSqlDmlErrorSelfTest.execute("copy from '" + path + "' into Simple  (_key, name) format csv", new Object[0]), CacheException.class, (String)"COPY command is currently supported only in thin JDBC driver.");
    }

    @Test
    public void testInsertMixingPlaceholderAndFields() {
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO COMPOSITE (_key, id2, name1, name2) VALUES (?, ?, ?, ?)", new CompositeKey(), 42, "name#1", "name#2"), "Column _KEY refers to entire key cache object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO COMPOSITE (id1, id2, _val, name2) VALUES (?, ?, ?, ?)", 1, 2, new CompositeValue(), "name#2"), "Column _VAL refers to entire value cache object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE (_key, id, name) VALUES (?, ?, ?)", 42, 43, "some name"), "Columns _KEY and ID both refer to entire cache key object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE (_key, _val, name) VALUES (?, ?, ?)", 42, "name#1", "name#2"), "Columns _VAL and NAME both refer to entire cache value object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO COMPOSITE (_key, id2, name1, name2) VALUES (?, ?, ?, ?)", new CompositeKey(), 42, "name#1", "name#2"), "Column _KEY refers to entire key cache object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO COMPOSITE (id1, id2, _val, name2) VALUES (?, ?, ?, ?)", 1, 2, new CompositeValue(), "name#2"), "Column _VAL refers to entire value cache object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO SIMPLE (_key, id, name) VALUES (?, ?, ?)", 42, 43, "some name"), "Columns _KEY and ID both refer to entire cache key object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO SIMPLE (_key, _val, name) VALUES (?, ?, ?)", 42, "name#1", "name#2"), "Columns _VAL and NAME both refer to entire cache value object.");
    }

    @Test
    public void testCopyMixingPlaceholderAndFields() {
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("COPY FROM 'stub/file/path' INTO SIMPLE (_key, id, name) FORMAT CSV", new Object[0]), "Columns _KEY and ID both refer to entire cache key object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("COPY FROM 'stub/file/path' INTO SIMPLE_WRAPPED (_key, id, name) FORMAT CSV", new Object[0]), "Column _KEY refers to entire key cache object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("COPY FROM 'stub/file/path' INTO SIMPLE (id, _val, name) FORMAT CSV", new Object[0]), "Columns _VAL and NAME both refer to entire cache value object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("COPY FROM 'stub/file/path' INTO SIMPLE_WRAPPED (id, _val, name) FORMAT CSV", new Object[0]), "Column _VAL refers to entire value cache object.");
    }

    @Test
    public void testUpdateMixingValueAndValueFields() {
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE COMPOSITE SET _val = ?, name2 = ?", new CompositeValue(), "name#2"), "Column _VAL refers to entire value cache object.");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET _val = ?, name = ?", "name#1", "name#2"), "Columns _VAL and NAME both refer to entire cache value object.");
    }

    @Test
    public void testInsertNullKeyValue() {
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO COMPOSITE (_key, _val) VALUES (?, ?)", null, new CompositeKey()), "Key for INSERT, COPY, or MERGE must not be null");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO COMPOSITE (_key, _val) VALUES (?, ?)", new CompositeKey(), null), "Value for INSERT, COPY, MERGE, or UPDATE must not be null");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE (_key, _val) VALUES(?, ?)", null, "name#1"), "Null value is not allowed for column 'ID'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE (id, _val) VALUES(?, ?)", null, "name#1"), "Null value is not allowed for column 'ID'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE (_key, _val) VALUES(?, ?)", 42, null), "Null value is not allowed for column 'NAME'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("INSERT INTO SIMPLE (_key, name) VALUES(?, ?)", 42, null), "Null value is not allowed for column 'NAME'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO COMPOSITE (_key, _val) VALUES (?, ?)", null, new CompositeKey()), "Key for INSERT, COPY, or MERGE must not be null");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO COMPOSITE (_key, _val) VALUES (?, ?)", new CompositeKey(), null), "Value for INSERT, COPY, MERGE, or UPDATE must not be null");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO SIMPLE (_key, _val) VALUES(?, ?)", null, "name#1"), "Null value is not allowed for column 'ID'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO SIMPLE (id, _val) VALUES(?, ?)", null, "name#1"), "Null value is not allowed for column 'ID'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO SIMPLE (_key, _val) VALUES(?, ?)", 42, null), "Null value is not allowed for column 'NAME'");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("MERGE INTO SIMPLE (_key, name) VALUES(?, ?)", 42, null), "Null value is not allowed for column 'NAME'");
    }

    @Test
    public void testUpdateKey() {
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE COMPOSITE SET _key = ?, _val = ?", new CompositeKey(), new CompositeValue()), "SQL UPDATE can't modify key or its fields directly");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE COMPOSITE SET id1 = ?, _val = ?", 42, new CompositeValue()), "SQL UPDATE can't modify key or its fields directly");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET _key = ?, _val = ?", 42, "simple name"), "SQL UPDATE can't modify key or its fields directly");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET id = ?, _val = ?", 42, "simple name"), "SQL UPDATE can't modify key or its fields directly");
    }

    @Test
    public void testUpdateKeyToNull() {
        String ANY_MESSAGE = "";
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE COMPOSITE SET _key = ?, _val = ?", null, new CompositeValue()), "");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET id = ?, _val = ?", null, "simple name"), "");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET id = ?, _val = ?", null, "simple name"), "");
    }

    @Test
    public void testUpdateValToNull() {
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE COMPOSITE SET _val = ?", new Object[]{null}), "New value for UPDATE must not be null");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET _val = ?", new Object[]{null}), "New value for UPDATE must not be null");
        this.assertThrows(() -> IgniteCacheSqlDmlErrorSelfTest.execute("UPDATE SIMPLE SET name = ?", new Object[]{null}), "New value for UPDATE must not be null");
    }

    private static List<List<?>> execute(String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC");
        if (!F.isEmpty((Object[])args)) {
            qry.setArgs(args);
        }
        return cache.query(qry).getAll();
    }

    private void assertThrows(Callable<?> qryClos, String expErrMsg) {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), qryClos, IgniteSQLException.class, (String)expErrMsg);
    }

    private static class CompositeValue {
        String name1 = UUID.randomUUID().toString();
        String name2 = UUID.randomUUID().toString();
    }

    private static class CompositeKey {
        int id1;
        int id2;

        public CompositeKey() {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            this.id1 = rnd.nextInt();
            this.id2 = rnd.nextInt();
        }
    }
}

