/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class IgniteCacheObjectKeyIndexingSelfTest
extends GridCommonAbstractTest {
    private static final int CACHE_SIZE = 20000;

    protected void afterTestsStopped() throws Exception {
        Ignition.stopAll((boolean)true);
        this.cleanPersistenceDir();
    }

    protected static CacheConfiguration<Object, TestObject> cacheCfg() {
        return new CacheConfiguration("default").setBackups(1).setIndexedTypes(new Class[]{Object.class, TestObject.class});
    }

    @Test
    public void testObjectKeyHandling() throws Exception {
        IgniteEx ignite = this.startGrid();
        IgniteCache cache = ignite.getOrCreateCache(IgniteCacheObjectKeyIndexingSelfTest.cacheCfg());
        UUID uid = UUID.randomUUID();
        cache.put((Object)uid, (Object)new TestObject("A"));
        this.assertItemsNumber(1L);
        cache.put((Object)1, (Object)new TestObject("B"));
        this.assertItemsNumber(2L);
        cache.put((Object)uid, (Object)new TestObject("C"));
        this.assertItemsNumber(2L);
        List res = cache.query(new SqlFieldsQuery("select _key, name from TestObject order by name")).getAll();
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((Object)res, Arrays.asList(Arrays.asList(1, "B"), Arrays.asList(uid, "C")));
        cache.remove((Object)1);
        this.assertItemsNumber(1L);
        res = cache.query(new SqlFieldsQuery("select _key, name from TestObject")).getAll();
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((Object)res, Collections.singletonList(Arrays.asList(uid, "C")));
        cache.remove((Object)uid);
        this.assertItemsNumber(0L);
    }

    @Test
    public void testObjectKeyHandlingDuringRebalance() throws Exception {
        this.startGrid(this.getTestIgniteInstanceName(0), this.createIgniteCfg(0));
        Ignite ign1 = this.startGrid(this.getTestIgniteInstanceName(1), this.createIgniteCfg(1));
        ign1.cluster().active(true);
        ign1.getOrCreateCache(IgniteCacheObjectKeyIndexingSelfTest.cacheCfg());
        Map<TestObject, TestObject> before = this.fillCache(1, false, () -> false);
        this.stopGrid(1);
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
        this.cleanPersistenceDir("node_1");
        this.startGrid(this.getTestIgniteInstanceName(1), this.createIgniteCfg(1));
        this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().topologyVersion());
        IgniteInternalFuture fut = this.grid(1).cachex("default").rebalance();
        Map<TestObject, TestObject> after = this.fillCache(2, true, () -> ((IgniteInternalFuture)fut).isDone());
        Assert.assertFalse((String)"Nothing was inserted during rebalance.", (boolean)after.isEmpty());
        fut.get(this.getTestTimeout());
        IgniteCache cache = this.grid(1).cache("default");
        for (Map.Entry<TestObject, TestObject> entry : before.entrySet()) {
            TestObject exp = after.getOrDefault(entry.getKey(), entry.getValue());
            List res = cache.query(new SqlFieldsQuery("select _val from TestObject where _key = ?").setArgs(new Object[]{entry.getKey()})).getAll();
            Assert.assertEquals(IgniteCacheObjectKeyIndexingSelfTest.createSingleColumnResult(exp), (Object)res);
        }
    }

    private static List<List<?>> createSingleColumnResult(TestObject val) {
        return Collections.singletonList(Collections.singletonList(val));
    }

    private Map<TestObject, TestObject> fillCache(int mul, boolean rnd, Supplier<Boolean> stop) {
        int i;
        log.info("Going to fill the cache");
        IgniteCache cache = this.grid(1).getOrCreateCache("default");
        HashMap<TestObject, TestObject> res = new HashMap<TestObject, TestObject>();
        for (i = 0; i < 20000 && !stop.get().booleanValue(); ++i) {
            int val = rnd ? ThreadLocalRandom.current().nextInt(20000) : i;
            TestObject tstObj = new TestObject(String.valueOf(val * mul));
            cache.put((Object)tstObj, (Object)tstObj);
            res.put(tstObj, tstObj);
            if ((i + 1) % 1000 != 0) continue;
            log.info("\t-> " + (i + 1) + " entries of " + 20000 + " has been inserted");
        }
        log.info("Cache is filled with " + i + " entries");
        return res;
    }

    private IgniteConfiguration createIgniteCfg(int id) {
        return new IgniteConfiguration().setGridLogger(log).setConsistentId((Serializable)((Object)("node_" + id))).setRebalanceBatchSize(64).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    private void assertItemsNumber(long num) {
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((long)num, (long)this.grid().cachex("default").size());
        IgniteCacheObjectKeyIndexingSelfTest.assertEquals((Object)num, ((List)this.grid().cache("default").query(new SqlFieldsQuery("select count(*) from TestObject")).getAll().get(0)).get(0));
    }

    private static class TestObject {
        @QuerySqlField
        @GridToStringInclude
        public final String name;

        private TestObject(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObject obj = (TestObject)o;
            return Objects.equals(this.name, obj.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return S.toString(TestObject.class, (Object)this);
        }
    }
}

