/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metric;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.metric.IndexPageCounter;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class IndexPagesMetricsPageDisplacementTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((FailureHandler)new StopNodeFailureHandler()).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Person.class})}).setDataStorageConfiguration(new DataStorageConfiguration().setPageSize(4096).setConcurrencyLevel(4).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC00000L).setPersistenceEnabled(true)));
    }

    @Test
    public void testPageDisplacement() throws Exception {
        long idxPagesInMemory;
        long idxPagesOnDisk;
        IgniteEx grid = this.startGrid(0);
        grid.cluster().state(ClusterState.ACTIVE);
        IndexPageCounter idxPageCounter = new IndexPageCounter(grid, true);
        IgniteInternalCache cache = grid.cachex("default");
        int grpId = cache.context().groupId();
        DataRegion dataRegion = grid.context().cache().context().database().dataRegion(null);
        PageMetrics pageMetrics = dataRegion.metrics().cacheGrpPageMetrics(grpId);
        IndexPagesMetricsPageDisplacementTest.assertEquals((long)(dataRegion.config().getMaxSize() + IgniteUtils.checkpointBufferSize((DataRegionConfiguration)dataRegion.config())), (long)LongStream.of((long[])GridTestUtils.getFieldValue((Object)dataRegion.pageMemory(), (String[])new String[]{"sizes"})).sum());
        int personId = 0;
        String namePrefix = IntStream.range(0, 1024).mapToObj(i -> "a").collect(Collectors.joining());
        do {
            int i2 = 0;
            while (i2 < 100) {
                cache.put((Object)personId, (Object)new Person(personId, namePrefix + "_name_" + personId, namePrefix + "_surname_" + personId));
                ++i2;
                ++personId;
            }
            this.forceCheckpoint((Ignite)grid);
            idxPagesOnDisk = this.getIdxPagesOnDisk(grid, grpId).size();
            idxPagesInMemory = idxPageCounter.countIdxPagesInMemory(grpId);
            Assert.assertThat((Object)pageMetrics.indexPages().value(), (Matcher)CoreMatchers.is((Object)idxPagesInMemory));
        } while (idxPagesOnDisk <= idxPagesInMemory);
        this.touchIdxPages(grid, grpId);
        long allIdxPagesInMemory = idxPageCounter.countIdxPagesInMemory(grpId);
        Assert.assertThat((Object)allIdxPagesInMemory, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(idxPagesInMemory)));
        Assert.assertThat((Object)pageMetrics.indexPages().value(), (Matcher)CoreMatchers.is((Object)allIdxPagesInMemory));
    }

    private void touchIdxPages(IgniteEx grid, int grpId) throws IgniteCheckedException {
        DataRegion dataRegion = grid.context().cache().context().database().dataRegion(null);
        PageMemory pageMemory = dataRegion.pageMemory();
        for (long pageId : this.getIdxPagesOnDisk(grid, grpId)) {
            pageMemory.acquirePage(grpId, pageId);
        }
    }

    private List<Long> getIdxPagesOnDisk(IgniteEx grid, int grpId) throws IgniteCheckedException {
        FilePageStoreManager pageStoreMgr = (FilePageStoreManager)grid.context().cache().context().pageStore();
        FilePageStore pageStore = (FilePageStore)pageStoreMgr.getStore(grpId, 65535);
        ArrayList<Long> result = new ArrayList<Long>();
        ByteBuffer buf = ByteBuffer.allocateDirect(pageStore.getPageSize()).order(ByteOrder.nativeOrder());
        long numPages = pageStore.size() / (long)pageStore.getPageSize() - 1L;
        int i = 0;
        while ((long)i < numPages) {
            long pageId = PageIdUtils.pageId((int)65535, (byte)0, (int)i);
            try {
                pageStore.read(pageId, buf, false);
            }
            catch (IgniteDataIntegrityViolationException igniteDataIntegrityViolationException) {
                // empty catch block
            }
            if (PageIO.isIndexPage((int)PageIO.getType((ByteBuffer)buf))) {
                result.add(PageIO.getPageId((ByteBuffer)buf));
            }
            buf.clear();
            ++i;
        }
        return result;
    }

    private static class Person {
        @QuerySqlField(index=true)
        private Integer id;
        @QuerySqlField(index=true)
        private String name;
        @QuerySqlField(index=true)
        private String surname;

        public Person(Integer id, String name, String surname) {
            this.id = id;
            this.name = name;
            this.surname = surname;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSurname() {
            return this.surname;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.surname);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Person)) {
                return false;
            }
            Person other = (Person)obj;
            return other.id.equals(this.id) && other.name.equals(this.name) && other.surname.equals(this.surname);
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

