/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.Config;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.Person;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class FunctionalQueryTest {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Test
    public void testQueries() throws Exception {
        IgniteConfiguration srvCfg = Config.getServerConfiguration();
        srvCfg.setBinaryConfiguration(new BinaryConfiguration().setTypeConfigurations(Arrays.asList(new BinaryTypeConfiguration(this.getClass().getName()), new BinaryTypeConfiguration(SerializedLambda.class.getName()))));
        try (Ignite ignored = Ignition.start((IgniteConfiguration)srvCfg);
             IgniteClient client = Ignition.startClient((ClientConfiguration)FunctionalQueryTest.getClientConfiguration());){
            ClientCache cache = client.getOrCreateCache("default");
            Map<Integer, Person> data = IntStream.rangeClosed(1, 100).boxed().collect(Collectors.toMap(i -> i, i -> new Person(i, String.format("Person %s", i))));
            cache.putAll(data);
            int minId = data.size() / 2 + 1;
            int pageSize = (data.size() - minId) / 3;
            int expSize = data.size() - minId + 1;
            Map<Integer, Person> exp = data.entrySet().stream().filter(e -> (Integer)e.getKey() >= minId).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<Query> queries = Arrays.asList(new ScanQuery((IgniteBiPredicate & Serializable)(i, p) -> p.getId() >= minId).setPageSize(pageSize), new SqlQuery(Person.class, "id >= ?").setArgs(new Object[]{minId}).setPageSize(pageSize));
            for (Query qry : queries) {
                QueryCursor cur = cache.query(qry);
                Throwable throwable = null;
                try {
                    List res = cur.getAll();
                    Assert.assertEquals((String)String.format("Unexpected number of rows from %s", qry.getClass().getSimpleName()), (long)expSize, (long)res.size());
                    Map<Integer, Person> act = res.stream().collect(Collectors.toMap(Cache.Entry::getKey, Cache.Entry::getValue));
                    Assert.assertEquals((String)String.format("unexpected rows from %s", qry.getClass().getSimpleName()), exp, act);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cur == null) continue;
                    if (throwable != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    cur.close();
                }
            }
            this.checkSqlFieldsQuery((ClientCache<Integer, Person>)cache, minId, pageSize, expSize, exp, true);
            this.checkSqlFieldsQuery((ClientCache<Integer, Person>)cache, minId, pageSize, expSize, exp, false);
        }
    }

    private void checkSqlFieldsQuery(ClientCache<Integer, Person> cache, int minId, int pageSize, int expSize, Map<Integer, Person> exp, boolean lazy) {
        SqlFieldsQuery qry = new SqlFieldsQuery("select id, name from Person where id >= ?").setArgs(new Object[]{minId}).setPageSize(pageSize).setLazy(lazy);
        try (FieldsQueryCursor cur = cache.query(qry);){
            Assert.assertEquals((long)2L, (long)cur.getColumnsCount());
            Assert.assertEquals((Object)"ID", (Object)cur.getFieldName(0));
            Assert.assertEquals((Object)"NAME", (Object)cur.getFieldName(1));
            List res = cur.getAll();
            Assert.assertEquals((long)expSize, (long)res.size());
            Map<Integer, Person> act = res.stream().collect(Collectors.toMap(r -> Integer.parseInt(r.get(0).toString()), r -> new Person(Integer.valueOf(Integer.parseInt(r.get(0).toString())), r.get(1).toString())));
            Assert.assertEquals(exp, act);
        }
    }

    @Test
    public void testSql() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             Ignite ignored2 = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            client.query(new SqlFieldsQuery(String.format("CREATE TABLE IF NOT EXISTS Person (id INT PRIMARY KEY, name VARCHAR) WITH \"VALUE_TYPE=%s\"", Person.class.getName())).setSchema("PUBLIC")).getAll();
            int KEY_COUNT = 10;
            for (int i = 0; i < 10; ++i) {
                int key = i;
                Person val = new Person(Integer.valueOf(key), "Person " + i);
                client.query(new SqlFieldsQuery("INSERT INTO Person(id, name) VALUES(?, ?)").setArgs(new Object[]{val.getId(), val.getName()}).setSchema("PUBLIC")).getAll();
            }
            Object cachedName = ((List)client.query(new SqlFieldsQuery("SELECT name from Person WHERE id=?").setArgs(new Object[]{1}).setSchema("PUBLIC")).getAll().iterator().next()).iterator().next();
            Assert.assertEquals((Object)"Person 1", cachedName);
            List rows = client.query(new SqlFieldsQuery("SELECT * from Person WHERE id >= ?").setSchema("PUBLIC").setArgs(new Object[]{0}).setPageSize(1)).getAll();
            Assert.assertEquals((long)10L, (long)rows.size());
        }
    }

    @Test
    public void testGettingEmptyResultWhenQueryingEmptyTable() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            String TBL = "Person";
            client.query(new SqlFieldsQuery(String.format("CREATE TABLE IF NOT EXISTS Person (id INT PRIMARY KEY, name VARCHAR) WITH \"VALUE_TYPE=%s\"", Person.class.getName())).setSchema("PUBLIC")).getAll();
            List res = client.query(new SqlFieldsQuery("SELECT * FROM Person")).getAll();
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((long)0L, (long)res.size());
            ClientCache cache = client.cache("SQL_PUBLIC_" + "Person".toUpperCase());
            res = cache.query(new SqlFieldsQuery("SELECT * FROM Person")).getAll();
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((long)0L, (long)res.size());
            List<Query> queries = Arrays.asList(new ScanQuery(), new SqlQuery(Person.class, "1 = 1"));
            for (Query qry : queries) {
                QueryCursor cur = cache.query(qry);
                Throwable throwable = null;
                try {
                    List res2 = cur.getAll();
                    Assert.assertNotNull((Object)res2);
                    Assert.assertEquals((long)0L, (long)res2.size());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cur == null) continue;
                    if (throwable != null) {
                        try {
                            cur.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    cur.close();
                }
            }
        }
    }

    @Test
    public void testGettingRowWithNullField() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            String TBL = "Person";
            client.query(new SqlFieldsQuery(String.format("CREATE TABLE IF NOT EXISTS Person (id INT PRIMARY KEY, name VARCHAR) WITH \"VALUE_TYPE=%s\"", Person.class.getName())).setSchema("PUBLIC")).getAll();
            boolean key = true;
            client.query(new SqlFieldsQuery("INSERT INTO Person(id, name) VALUES(1, NULL)").setSchema("PUBLIC")).getAll();
            List res = client.query(new SqlFieldsQuery("SELECT * FROM Person")).getAll();
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((long)1L, (long)res.size());
            List row = (List)res.get(0);
            Assert.assertEquals(row.get(0), (Object)1);
            Assert.assertNull(row.get(1));
        }
    }

    @Test
    public void testMixedQueryAndCacheApiOperations() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setBinaryConfiguration(new BinaryConfiguration().setCompactFooter(true)).setAddresses(new String[]{"127.0.0.1:10800"}));){
            String cacheName = "PersonCache";
            client.query(new SqlFieldsQuery(String.format("CREATE TABLE IF NOT EXISTS Person (key INT PRIMARY KEY, name VARCHAR) WITH \"VALUE_TYPE=%s,CACHE_NAME=%s\"", Person.class.getName(), cacheName)).setSchema("PUBLIC")).getAll();
            client.query(new SqlFieldsQuery("INSERT INTO Person(key, name) VALUES(?, ?)").setArgs(new Object[]{1, "Person 1"}).setSchema("PUBLIC")).getAll();
            ClientCache cache = client.cache(cacheName);
            cache.put((Object)2, (Object)new Person(Integer.valueOf(2), "Person 2"));
            Assert.assertEquals((Object)"Person 1", (Object)((Person)cache.get((Object)1)).getName());
            Assert.assertEquals((Object)"Person 2", ((List)client.query(new SqlFieldsQuery("SELECT name FROM PUBLIC.Person WHERE key = 2")).getAll().get(0)).get(0));
        }
    }

    @Test
    public void testSqlParameterValidation() throws Exception {
        try (Ignite ignored = Ignition.start((IgniteConfiguration)Config.getServerConfiguration());
             IgniteClient client = Ignition.startClient((ClientConfiguration)new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}));){
            SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM Person");
            Field updateBatchSize = SqlFieldsQuery.class.getDeclaredField("updateBatchSize");
            updateBatchSize.setAccessible(true);
            updateBatchSize.setInt(qry, -1);
            GridTestUtils.assertThrowsAnyCause(null, () -> client.query(qry).getAll(), ClientException.class, (String)"updateBatchSize cannot be lower than 1");
            Field parts = SqlFieldsQuery.class.getDeclaredField("parts");
            parts.setAccessible(true);
            parts.set(qry, new int[]{-1});
            qry.setUpdateBatchSize(2);
            GridTestUtils.assertThrowsAnyCause(null, () -> client.query(qry).getAll(), ClientException.class, (String)"Illegal partition");
        }
    }

    private static ClientConfiguration getClientConfiguration() {
        return new ClientConfiguration().setAddresses(new String[]{"127.0.0.1:10800"}).setSendBufferSize(0).setReceiveBufferSize(0);
    }
}

