/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.causality.IncrementalVersionedValue;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.PartitionSet;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.distributed.index.IndexUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.LongPriorityQueue;
import org.apache.ignite.lang.ErrorGroups;

public class IndexManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(IndexManager.class);
    private final SchemaManager schemaManager;
    private final TableManager tableManager;
    private final CatalogService catalogService;
    private final ExecutorService ioExecutor;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IncrementalVersionedValue<Void> handleMetastoreEventVv;
    private final LowWatermark lowWatermark;
    private final LongPriorityQueue<DestroyIndexEvent> destructionEventsQueue = new LongPriorityQueue(DestroyIndexEvent::catalogVersion);

    public IndexManager(SchemaManager schemaManager, TableManager tableManager, CatalogService catalogService, ExecutorService ioExecutor, RevisionListenerRegistry registry, LowWatermark lowWatermark) {
        this.schemaManager = schemaManager;
        this.tableManager = tableManager;
        this.catalogService = catalogService;
        this.ioExecutor = ioExecutor;
        this.lowWatermark = lowWatermark;
        this.handleMetastoreEventVv = new IncrementalVersionedValue("IndexManager#handleMetastoreEvent", registry);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        LOG.debug("Index manager is about to start", new Object[0]);
        this.recoverDestructionQueue();
        this.catalogService.listen((Event)CatalogEvent.INDEX_CREATE, parameters -> this.onIndexCreate((CreateIndexEventParameters)parameters));
        this.catalogService.listen((Event)CatalogEvent.INDEX_REMOVED, EventListener.fromConsumer(this::onIndexRemoved));
        this.lowWatermark.listen((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, parameters -> this.onLwmChanged((ChangeLowWatermarkEventParameters)parameters));
        LOG.info("Index manager started", new Object[0]);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        LOG.debug("Index manager is about to stop", new Object[0]);
        if (!this.stopGuard.compareAndSet(false, true)) {
            LOG.debug("Index manager already stopped", new Object[0]);
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        LOG.info("Index manager stopped", new Object[0]);
        return CompletableFutures.nullCompletedFuture();
    }

    CompletableFuture<MvTableStorage> getMvTableStorage(long causalityToken, int tableId) {
        return this.tableManager.tableAsync(causalityToken, tableId).thenApply(table -> {
            if (table == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Table does not exist [tableId = {}]", new Object[]{tableId});
            }
            MvTableStorage storage = table.internalTable().storage();
            if (storage == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Table storage for the specified table cannot be null [tableId = {}]", new Object[]{tableId});
            }
            return storage;
        });
    }

    private CompletableFuture<Boolean> onIndexCreate(CreateIndexEventParameters parameters) {
        return IgniteUtils.inBusyLockAsync((IgniteBusyLock)this.busyLock, () -> {
            CatalogIndexDescriptor index = parameters.indexDescriptor();
            int indexId = index.id();
            int tableId = index.tableId();
            long causalityToken = parameters.causalityToken();
            int catalogVersion = parameters.catalogVersion();
            CatalogTableDescriptor table = this.catalogService.catalog(catalogVersion).table(tableId);
            assert (table != null) : "tableId=" + tableId + ", indexId=" + indexId;
            if (LOG.isInfoEnabled()) {
                LOG.info("Creating local index: name={}, id={}, tableId={}, token={}, type={}", new Object[]{index.name(), indexId, tableId, causalityToken, index.indexType()});
            }
            return this.startIndexAsync(table, index, causalityToken).thenApply(unused -> false);
        });
    }

    private void onIndexRemoved(RemoveIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            int indexId = parameters.indexId();
            int catalogVersion = parameters.catalogVersion();
            int previousCatalogVersion = catalogVersion - 1;
            CatalogIndexDescriptor indexDescriptor = this.catalogService.catalog(previousCatalogVersion).index(indexId);
            assert (indexDescriptor != null) : "indexId=" + indexId + ", catalogVersion=" + previousCatalogVersion;
            int tableId = indexDescriptor.tableId();
            if (this.catalogService.catalog(catalogVersion).table(tableId) == null) {
                return;
            }
            this.destructionEventsQueue.enqueue((Object)new DestroyIndexEvent(catalogVersion, indexId, tableId));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.falseCompletedFuture();
        }
        try {
            int newEarliestCatalogVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
            List events = this.destructionEventsQueue.drainUpTo((long)newEarliestCatalogVersion);
            CompletableFuture.runAsync(() -> events.forEach(event -> this.destroyIndex(event.indexId(), event.tableId())), this.ioExecutor).whenComplete((v, e) -> {
                if (e != null) {
                    LOG.error("Unable to destroy indices", e);
                }
            });
            CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void destroyIndex(int indexId, int tableId) {
        TableViewInternal table = this.tableManager.cachedTable(tableId);
        if (table != null) {
            table.unregisterIndex(indexId);
        }
    }

    private CompletableFuture<?> startIndexAsync(CatalogTableDescriptor table, CatalogIndexDescriptor index, long causalityToken) {
        int tableId = index.tableId();
        CompletableFuture tablePartitionFuture = this.tableManager.localPartitionSetAsync(causalityToken, tableId);
        CompletableFuture schemaRegistryFuture = this.schemaManager.schemaRegistry(causalityToken, tableId);
        return this.handleMetastoreEventVv.update(causalityToken, IndexManager.updater(mvTableStorageById -> tablePartitionFuture.thenCombineAsync((CompletionStage)schemaRegistryFuture, (partitionSet, schemaRegistry) -> (Void)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            this.registerIndex(table, index, (PartitionSet)partitionSet, (SchemaRegistry)schemaRegistry);
            return null;
        }), (Executor)this.ioExecutor)));
    }

    private void registerIndex(CatalogTableDescriptor table, CatalogIndexDescriptor index, PartitionSet partitionSet, SchemaRegistry schemaRegistry) {
        TableViewInternal tableView = this.getTableViewStrict(table.id());
        IndexUtils.registerIndexToTable((TableViewInternal)tableView, (CatalogTableDescriptor)table, (CatalogIndexDescriptor)index, (PartitionSet)partitionSet, (SchemaRegistry)schemaRegistry);
    }

    private TableViewInternal getTableViewStrict(int tableId) {
        TableViewInternal table = this.tableManager.cachedTable(tableId);
        assert (table != null) : tableId;
        return table;
    }

    private static <T> BiFunction<T, Throwable, CompletableFuture<T>> updater(Function<T, CompletableFuture<T>> updateFunction) {
        return (t, throwable) -> {
            if (throwable != null) {
                return CompletableFuture.failedFuture(throwable);
            }
            return (CompletableFuture)updateFunction.apply(t);
        };
    }

    private void recoverDestructionQueue() {
        HybridTimestamp lwm = this.lowWatermark.getLowWatermark();
        int earliestCatalogVersion = lwm == null ? this.catalogService.earliestCatalogVersion() : this.catalogService.activeCatalogVersion(lwm.longValue());
        int latestCatalogVersion = this.catalogService.latestCatalogVersion();
        Catalog nextCatalog = this.catalogService.catalog(latestCatalogVersion);
        assert (nextCatalog != null) : "catalogVersion=" + latestCatalogVersion;
        for (int catalogVersion = latestCatalogVersion - 1; catalogVersion >= earliestCatalogVersion; --catalogVersion) {
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            assert (catalog != null) : "catalogVersion=" + catalogVersion;
            for (CatalogIndexDescriptor index : catalog.indexes()) {
                int indexId = index.id();
                int tableId = index.tableId();
                if (nextCatalog.index(indexId) != null || nextCatalog.table(tableId) == null) continue;
                this.destructionEventsQueue.enqueue((Object)new DestroyIndexEvent(nextCatalog.version(), indexId, tableId));
            }
            nextCatalog = catalog;
        }
    }

    private static class DestroyIndexEvent {
        final int catalogVersion;
        final int indexId;
        final int tableId;

        DestroyIndexEvent(int catalogVersion, int indexId, int tableId) {
            this.catalogVersion = catalogVersion;
            this.indexId = indexId;
            this.tableId = tableId;
        }

        int catalogVersion() {
            return this.catalogVersion;
        }

        int indexId() {
            return this.indexId;
        }

        int tableId() {
            return this.tableId;
        }
    }
}

