/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.index.IndexBuildTaskId;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class IndexBuildTaskStatisticsLoggingListener {
    private static final IgniteLogger LOG = Loggers.forClass(IndexBuildTaskStatisticsLoggingListener.class);
    private final IndexBuildTaskId taskId;
    private final boolean afterDisasterRecovery;
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicInteger successfulRaftCallCount = new AtomicInteger(0);
    private final AtomicInteger failedRaftCallCount = new AtomicInteger(0);
    private final AtomicLong rowIndexedCount = new AtomicLong(0L);
    private final ConcurrentMap<TxState, AtomicInteger> resolvedWriteIntentCount = new ConcurrentHashMap<TxState, AtomicInteger>();

    IndexBuildTaskStatisticsLoggingListener(IndexBuildTaskId taskId, boolean afterDisasterRecovery) {
        this.taskId = taskId;
        this.afterDisasterRecovery = afterDisasterRecovery;
    }

    void onIndexBuildStarted() {
        this.startTime.set(System.nanoTime());
    }

    TxState onWriteIntentResolved(TxState txState) {
        this.resolvedWriteIntentCount.computeIfAbsent(txState, unused -> new AtomicInteger(0)).incrementAndGet();
        return txState;
    }

    void onRaftCallSuccess() {
        this.successfulRaftCallCount.incrementAndGet();
    }

    void onRaftCallFailure() {
        this.failedRaftCallCount.incrementAndGet();
    }

    void onBatchProcessed(int rowCount) {
        this.rowIndexedCount.addAndGet(rowCount);
    }

    void onIndexBuildSuccess() {
        this.logStatistics(null);
    }

    void onIndexBuildFailure(Throwable throwable) {
        this.logStatistics(throwable);
    }

    private void logStatistics(@Nullable Throwable throwable) {
        long time = this.getBuildTime();
        String status = throwable == null ? "SUCCESS" : String.format("FAILURE [error=%s]", ExceptionUtils.unwrapCause((Throwable)throwable));
        String buildReason = this.afterDisasterRecovery ? "DISASTER_RECOVERY" : "BUILD";
        LOG.info("Index build statistics [status={}, taskId={}, buildReason={}, time={}ms, rowsIndexed={}, successfulRaftCalls={}, failedRaftCalls={}, resolvedWriteIntents={}]", new Object[]{status, this.taskId, buildReason, time, this.rowIndexedCount, this.successfulRaftCallCount, this.failedRaftCallCount, this.resolvedWriteIntentCount});
    }

    private long getBuildTime() {
        assert (this.startTime.get() != 0L) : "startTime was not initialized before measuring index build time";
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime.get());
    }

    @TestOnly
    AtomicLong startTime() {
        return this.startTime;
    }

    @TestOnly
    Map<TxState, AtomicInteger> resolvedWriteIntentCount() {
        return this.resolvedWriteIntentCount;
    }

    @TestOnly
    AtomicLong rowIndexedCount() {
        return this.rowIndexedCount;
    }

    @TestOnly
    AtomicInteger successfulRaftCallCount() {
        return this.successfulRaftCallCount;
    }

    @TestOnly
    AtomicInteger failedRaftCallCount() {
        return this.failedRaftCallCount;
    }
}

