/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.ChangeIndexStatusValidationException;
import org.apache.ignite.internal.catalog.IndexNotFoundValidationException;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.index.IndexManagementUtils;
import org.apache.ignite.internal.index.IndexTaskStoppingException;
import org.apache.ignite.internal.index.NodeLeftLogicalTopologyListener;
import org.apache.ignite.internal.index.message.IndexMessagesFactory;
import org.apache.ignite.internal.index.message.IsNodeFinishedRwTransactionsStartedBeforeRequest;
import org.apache.ignite.internal.index.message.IsNodeFinishedRwTransactionsStartedBeforeResponse;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.RecipientLeftException;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitException;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitTimeoutException;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.table.distributed.index.IndexMeta;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;

abstract class ChangeIndexStatusTask {
    private static final IgniteLogger LOG = Loggers.forClass(ChangeIndexStatusTask.class);
    private static final IndexMessagesFactory FACTORY = new IndexMessagesFactory();
    private static final int INVOKE_MESSAGE_TIMEOUT_MILLS = 1000;
    private static final int RETRY_SEND_MESSAGE_TIMEOUT_MILLS = 100;
    private final CatalogIndexDescriptor indexDescriptor;
    private final CatalogManager catalogManager;
    private final PlacementDriver placementDriver;
    private final ClusterService clusterService;
    private final LogicalTopologyService logicalTopologyService;
    private final ClockService clockService;
    private final IndexMetaStorage indexMetaStorage;
    private final FailureProcessor failureProcessor;
    private final Executor executor;
    private final IgniteSpinBusyLock busyLock;
    private final IgniteSpinBusyLock taskBusyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean taskStopGuard = new AtomicBoolean();

    ChangeIndexStatusTask(CatalogIndexDescriptor indexDescriptor, CatalogManager catalogManager, PlacementDriver placementDriver, ClusterService clusterService, LogicalTopologyService logicalTopologyService, ClockService clockService, IndexMetaStorage indexMetaStorage, FailureProcessor failureProcessor, Executor executor, IgniteSpinBusyLock busyLock) {
        this.indexDescriptor = indexDescriptor;
        this.catalogManager = catalogManager;
        this.placementDriver = placementDriver;
        this.clusterService = clusterService;
        this.logicalTopologyService = logicalTopologyService;
        this.clockService = clockService;
        this.indexMetaStorage = indexMetaStorage;
        this.failureProcessor = failureProcessor;
        this.executor = executor;
        this.busyLock = busyLock;
    }

    CompletableFuture<Void> start() {
        if (!this.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            LOG.debug("Starting task to change index status. Index: {}", new Object[]{this.indexDescriptor});
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.awaitCatalogVersionActivation().thenComposeAsync(unused -> this.ensureThatLocalNodeStillPrimaryReplica(), this.executor)).thenComposeAsync(unused -> this.inBusyLocks(() -> ((LogicalTopologyService)this.logicalTopologyService).logicalTopologyOnLeader()), this.executor)).thenComposeAsync(this::awaitFinishRwTxsBeforeCatalogVersion, this.executor)).thenComposeAsync(unused -> this.inBusyLocks(() -> this.catalogManager.execute(this.switchIndexStatusCommand())), this.executor)).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    this.handleStatusSwitchException((Throwable)throwable);
                }
            })).thenApply(unused -> null);
            return completionStage;
        }
        finally {
            this.leaveBusy();
        }
    }

    private void handleStatusSwitchException(Throwable throwable) {
        if (ExceptionUtils.hasCause((Throwable)throwable, (Class[])new Class[]{IndexTaskStoppingException.class, NodeStoppingException.class, IndexNotFoundValidationException.class, ChangeIndexStatusValidationException.class, PrimaryReplicaAwaitException.class})) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stop index operation due to an expected exception; index operation is either requested to be stopped or it will be picked up later", throwable);
            } else {
                LOG.info("Stop index operation due to an expected exception; index operation is either requested to be stopped or it will be picked up later [exceptionClass={}, message={}]", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
            }
        } else {
            this.failureProcessor.process(new FailureContext(throwable, String.format("Error starting index task: %s", this.indexDescriptor.id())));
        }
    }

    abstract CatalogCommand switchIndexStatusCommand();

    void stop() {
        if (!this.taskStopGuard.compareAndSet(false, true)) {
            return;
        }
        this.taskBusyLock.block();
    }

    CatalogIndexDescriptor targetIndex() {
        return this.indexDescriptor;
    }

    private CompletableFuture<Void> awaitCatalogVersionActivation() {
        CompletableFuture<HybridTimestamp> activationTimestampFuture = CompletableFuture.supplyAsync(() -> {
            if (!this.enterBusy()) {
                throw new IndexTaskStoppingException();
            }
            try {
                HybridTimestamp hybridTimestamp = CatalogUtils.clusterWideEnsuredActivationTimestamp((long)this.statusChange().activationTimestamp(), (long)this.clockService.maxClockSkewMillis());
                return hybridTimestamp;
            }
            finally {
                this.leaveBusy();
            }
        }, this.executor);
        return activationTimestampFuture.thenCompose(arg_0 -> ((ClockService)this.clockService).waitFor(arg_0));
    }

    private CompletableFuture<Void> ensureThatLocalNodeStillPrimaryReplica() {
        return this.awaitPrimaryReplica().thenAccept(replicaMeta -> {
            if (!this.enterBusy()) {
                throw new IndexTaskStoppingException();
            }
            try {
                if (!IndexManagementUtils.isPrimaryReplica(replicaMeta, IndexManagementUtils.localNode(this.clusterService), this.clockService.now())) {
                    throw new IndexTaskStoppingException();
                }
            }
            finally {
                this.leaveBusy();
            }
        });
    }

    private CompletableFuture<ReplicaMeta> awaitPrimaryReplica() {
        return this.inBusyLocks(() -> {
            IndexMeta indexMeta = this.indexMetaStorage.indexMeta(this.indexDescriptor.id());
            if (indexMeta == null) {
                throw new IndexTaskStoppingException();
            }
            CatalogTableDescriptor tableDescriptor = this.catalogManager.catalog(indexMeta.catalogVersion()).table(this.indexDescriptor.tableId());
            if (tableDescriptor == null) {
                throw new IndexTaskStoppingException();
            }
            ZonePartitionId groupId = new ZonePartitionId(tableDescriptor.zoneId(), 0);
            return ((CompletableFuture)this.placementDriver.awaitPrimaryReplica((ReplicationGroupId)groupId, this.clockService.now(), 10L, TimeUnit.SECONDS).handle((replicaMeta, throwable) -> {
                if (throwable != null) {
                    Throwable cause = ExceptionUtils.unwrapCause((Throwable)throwable);
                    if (cause instanceof PrimaryReplicaAwaitTimeoutException) {
                        return this.awaitPrimaryReplica();
                    }
                    return CompletableFuture.failedFuture(cause);
                }
                return CompletableFuture.completedFuture(replicaMeta);
            })).thenCompose(Function.identity());
        });
    }

    private CompletableFuture<Void> awaitFinishRwTxsBeforeCatalogVersion(LogicalTopologySnapshot logicalTopologySnapshot) {
        return this.inBusyLocks(() -> {
            ConcurrentHashMap.KeySetView remainingNodes = ConcurrentHashMap.newKeySet();
            remainingNodes.addAll(logicalTopologySnapshot.nodes());
            NodeLeftLogicalTopologyListener nodeLeftLogicalTopologyListener = new NodeLeftLogicalTopologyListener(remainingNodes);
            this.logicalTopologyService.addEventListener((LogicalTopologyEventListener)nodeLeftLogicalTopologyListener);
            CompletableFuture[] futures = (CompletableFuture[])remainingNodes.stream().map(node -> this.awaitFinishRwTxsBeforeCatalogVersion((LogicalNode)node, remainingNodes)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures).whenComplete((unused, throwable) -> this.logicalTopologyService.removeEventListener((LogicalTopologyEventListener)nodeLeftLogicalTopologyListener));
        });
    }

    private CompletableFuture<Void> awaitFinishRwTxsBeforeCatalogVersion(LogicalNode targetNode, Set<LogicalNode> remainingNodes) {
        return this.inBusyLocks(() -> {
            if (!remainingNodes.contains(targetNode)) {
                return CompletableFutures.nullCompletedFuture();
            }
            IsNodeFinishedRwTransactionsStartedBeforeRequest request = this.isNodeFinishedRwTransactionsStartedBeforeRequest();
            return ((CompletableFuture)this.clusterService.messagingService().invoke((InternalClusterNode)targetNode, (NetworkMessage)request, 1000L).exceptionally(throwable -> {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)throwable);
                if (!(cause instanceof TimeoutException) && !(cause instanceof RecipientLeftException)) {
                    throw new CompletionException(cause);
                }
                return null;
            })).thenCompose(message -> {
                if (message != null && ((IsNodeFinishedRwTransactionsStartedBeforeResponse)message).finished()) {
                    LOG.debug("All transactions have finished on node {}. Remaining nodes: {}", new Object[]{targetNode, remainingNodes});
                    remainingNodes.remove(targetNode);
                    return CompletableFutures.nullCompletedFuture();
                }
                return this.inBusyLocks(() -> {
                    Executor delayedExecutor = CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS, this.executor);
                    return CompletableFuture.supplyAsync(() -> this.awaitFinishRwTxsBeforeCatalogVersion(targetNode, remainingNodes), delayedExecutor).thenCompose(Function.identity());
                });
            });
        });
    }

    private IsNodeFinishedRwTransactionsStartedBeforeRequest isNodeFinishedRwTransactionsStartedBeforeRequest() {
        return FACTORY.isNodeFinishedRwTransactionsStartedBeforeRequest().targetCatalogVersion(this.statusChange().catalogVersion()).build();
    }

    private boolean enterBusy() {
        return IndexManagementUtils.enterBusy(this.busyLock, this.taskBusyLock);
    }

    private void leaveBusy() {
        IndexManagementUtils.leaveBusy(this.busyLock, this.taskBusyLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletableFuture<T> inBusyLocks(Supplier<CompletableFuture<T>> supplier) {
        if (!this.enterBusy()) {
            return CompletableFuture.failedFuture(new IndexTaskStoppingException());
        }
        try {
            CompletableFuture<T> completableFuture = supplier.get();
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    private MetaIndexStatusChange statusChange() {
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(this.indexDescriptor.id());
        if (indexMeta == null) {
            throw new IndexTaskStoppingException();
        }
        MetaIndexStatusChange statusChange = indexMeta.statusChangeNullable(MetaIndexStatus.convert((CatalogIndexStatus)this.indexDescriptor.status()));
        assert (statusChange != null) : IgniteStringFormatter.format((String)"Missing index status change: [indexId={}, catalogStatus={}]", (Object[])new Object[]{this.indexDescriptor.id(), this.indexDescriptor.status()});
        return statusChange;
    }
}

