/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.index.ChangeIndexStatusTaskController;
import org.apache.ignite.internal.index.ChangeIndexStatusTaskScheduler;
import org.apache.ignite.internal.index.IndexAvailabilityController;
import org.apache.ignite.internal.index.IndexBuildController;
import org.apache.ignite.internal.index.IndexBuilder;
import org.apache.ignite.internal.index.IndexManager;
import org.apache.ignite.internal.index.RetryingFinalTransactionStateResolver;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.wrappers.ExecutorInclinedPlacementDriver;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.replicator.TransactionStateResolver;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class IndexBuildingManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(IndexBuildingManager.class);
    private final MetaStorageManager metaStorageManager;
    private final ThreadPoolExecutor executor;
    private final IndexBuilder indexBuilder;
    private final IndexAvailabilityController indexAvailabilityController;
    private final IndexBuildController indexBuildController;
    private final ChangeIndexStatusTaskController changeIndexStatusTaskController;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    public IndexBuildingManager(String nodeName, ReplicaService replicaService, CatalogManager catalogManager, MetaStorageManager metaStorageManager, IndexManager indexManager, IndexMetaStorage indexMetaStorage, PlacementDriver placementDriver, ClusterService clusterService, LogicalTopologyService logicalTopologyService, ClockService clockService, FailureProcessor failureProcessor, LowWatermark lowWatermark, TxManager txManager, MetricManager metricManager) {
        this.metaStorageManager = metaStorageManager;
        int threadCount = Runtime.getRuntime().availableProcessors();
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"build-index", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        this.executor.allowCoreThreadTimeOut(true);
        TransactionStateResolver transactionStateResolver = new TransactionStateResolver(txManager, clockService, (ClusterNodeResolver)clusterService.topologyService(), clusterService.messagingService(), (PlacementDriver)new ExecutorInclinedPlacementDriver(placementDriver, (Executor)this.executor), new TxMessageSender(clusterService.messagingService(), replicaService, clockService));
        this.indexBuilder = new IndexBuilder(this.executor, replicaService, failureProcessor, new RetryingFinalTransactionStateResolver(transactionStateResolver, this.executor), indexMetaStorage, metricManager);
        this.indexAvailabilityController = new IndexAvailabilityController(catalogManager, metaStorageManager, failureProcessor, this.indexBuilder);
        this.indexBuildController = new IndexBuildController(this.indexBuilder, indexManager, (CatalogService)catalogManager, clusterService, placementDriver, clockService, failureProcessor);
        ChangeIndexStatusTaskScheduler indexTaskScheduler = new ChangeIndexStatusTaskScheduler(catalogManager, clusterService, logicalTopologyService, clockService, placementDriver, indexMetaStorage, failureProcessor, this.executor);
        this.changeIndexStatusTaskController = new ChangeIndexStatusTaskController(catalogManager, placementDriver, clusterService, lowWatermark, indexTaskScheduler);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync((IgniteBusyLock)this.busyLock, () -> {
            CompletableFuture recoveryFinishedFuture = this.metaStorageManager.recoveryFinishedFuture();
            assert (recoveryFinishedFuture.isDone());
            long recoveryRevision = ((Revisions)recoveryFinishedFuture.join()).revision();
            this.indexAvailabilityController.start(recoveryRevision);
            this.changeIndexStatusTaskController.start();
            this.indexBuildController.start();
            return CompletableFutures.nullCompletedFuture();
        });
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        try {
            IgniteUtils.closeAllManually((ManuallyCloseable[])new ManuallyCloseable[]{this.indexBuilder, this.indexAvailabilityController, this.indexBuildController, this.changeIndexStatusTaskController, () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS)});
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

