/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.index.IndexBuildTaskId;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;

public class IndexBuilderMetricSource
extends AbstractMetricSource<Holder> {
    public static final String METRIC_GROUP = "index.builder";
    private final Map<IndexBuildTaskId, Integer> transactionsToResolveByTaskId = new ConcurrentHashMap<IndexBuildTaskId, Integer>();
    private final Set<IndexBuildTaskId> indexesReading = ConcurrentHashMap.newKeySet();
    private final Set<IndexBuildTaskId> indexesWaitingForResponse = ConcurrentHashMap.newKeySet();
    private final Set<IndexBuildTaskId> indexesBuilding = ConcurrentHashMap.newKeySet();

    public IndexBuilderMetricSource() {
        super(METRIC_GROUP, "Index builder metrics.");
    }

    protected Holder createHolder() {
        return new Holder();
    }

    void onBatchProcessingStarted(IndexBuildTaskId taskId) {
        this.indexesBuilding.add(taskId);
        this.indexesReading.add(taskId);
    }

    void onTransitionToWaitingForTransactions(IndexBuildTaskId taskId, int transactionsToWait) {
        this.indexesReading.remove(taskId);
        this.transactionsToResolveByTaskId.put(taskId, transactionsToWait);
    }

    void onTransitionToWaitingForReplicaResponse(IndexBuildTaskId taskId) {
        this.transactionsToResolveByTaskId.remove(taskId);
        this.indexesWaitingForResponse.add(taskId);
    }

    void onBatchProcessingFinished(IndexBuildTaskId taskId) {
        this.indexesReading.remove(taskId);
        this.indexesWaitingForResponse.remove(taskId);
        this.transactionsToResolveByTaskId.remove(taskId);
        this.indexesBuilding.remove(taskId);
    }

    public class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final IntGauge totalIndexesBuilding = new IntGauge("TotalIndexesBuilding", "Total number of indexes that node builds at the moment.", IndexBuilderMetricSource.this.indexesBuilding::size);
        private final IntGauge indexesReadingStorage = new IntGauge("IndexesReadingStorage", "Number of indexes that are currently reading data from storage.", IndexBuilderMetricSource.this.indexesReading::size);
        private final IntGauge indexesWaitingForTransaction = new IntGauge("IndexesWaitingForTransactions", "Number of indexes that are currently waiting for transactions to complete.", IndexBuilderMetricSource.this.transactionsToResolveByTaskId::size);
        private final IntGauge transactionsWaitingFor = new IntGauge("TransactionsWaitingFor", "Number of transactions that indexes are currently waiting for.", () -> IndexBuilderMetricSource.this.transactionsToResolveByTaskId.values().stream().mapToInt(Integer::intValue).sum());
        private final IntGauge indexesWaitingForReplica = new IntGauge("IndexesWaitingForReplica", "Number of indexes that are currently waiting for replica response.", IndexBuilderMetricSource.this.indexesWaitingForResponse::size);
        private final List<Metric> metrics = List.of(this.totalIndexesBuilding, this.indexesReadingStorage, this.indexesWaitingForTransaction, this.transactionsWaitingFor, this.indexesWaitingForReplica);

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

