/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntPredicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.catalog.events.StoppingIndexEventParameters;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.index.ChangeIndexStatusTaskScheduler;
import org.apache.ignite.internal.index.IndexManagementUtils;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.table.LongPriorityQueue;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

class ChangeIndexStatusTaskController
implements ManuallyCloseable {
    private final CatalogService catalogService;
    private final PlacementDriver placementDriver;
    private final ClusterService clusterService;
    private final LowWatermark lowWatermark;
    private final NodeProperties nodeProperties;
    private final ChangeIndexStatusTaskScheduler changeIndexStatusTaskScheduler;
    private final Set<Integer> localNodeIsPrimaryReplicaForTableIds = ConcurrentHashMap.newKeySet();
    private final Set<Integer> localNodeIsPrimaryReplicaForZoneIds = ConcurrentHashMap.newKeySet();
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue(DestroyTableEvent::catalogVersion);
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();

    ChangeIndexStatusTaskController(CatalogManager catalogManager, PlacementDriver placementDriver, ClusterService clusterService, LowWatermark lowWatermark, NodeProperties nodeProperties, ChangeIndexStatusTaskScheduler changeIndexStatusTaskScheduler) {
        this.catalogService = catalogManager;
        this.placementDriver = placementDriver;
        this.clusterService = clusterService;
        this.lowWatermark = lowWatermark;
        this.nodeProperties = nodeProperties;
        this.changeIndexStatusTaskScheduler = changeIndexStatusTaskScheduler;
    }

    public void start() {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, this::addListeners);
    }

    public void close() throws Exception {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.changeIndexStatusTaskScheduler.close();
    }

    private void addListeners() {
        this.catalogService.listen((Event)CatalogEvent.INDEX_CREATE, EventListener.fromConsumer(this::onIndexCreated));
        this.catalogService.listen((Event)CatalogEvent.INDEX_STOPPING, EventListener.fromConsumer(this::onIndexDropped));
        this.catalogService.listen((Event)CatalogEvent.INDEX_REMOVED, EventListener.fromConsumer(this::onIndexRemoved));
        if (this.nodeProperties.colocationEnabled()) {
            this.catalogService.listen((Event)CatalogEvent.TABLE_CREATE, EventListener.fromConsumer(this::onTableCreated));
            this.catalogService.listen((Event)CatalogEvent.TABLE_DROP, EventListener.fromConsumer(this::onTableDropped));
            this.lowWatermark.listen((Event)LowWatermarkEvent.LOW_WATERMARK_CHANGED, EventListener.fromConsumer(this::onLwmChanged));
        }
        this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, EventListener.fromConsumer(this::onPrimaryReplicaElected));
    }

    private void onIndexCreated(CreateIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            CatalogIndexDescriptor indexDescriptor = parameters.indexDescriptor();
            if (indexDescriptor.isCreatedWithTable()) {
                return;
            }
            if (this.localNodeIsPrimaryReplicaForTableIds.contains(indexDescriptor.tableId())) {
                this.changeIndexStatusTaskScheduler.scheduleStartBuildingTask(parameters.indexDescriptor());
            }
        });
    }

    private void onIndexDropped(StoppingIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            Catalog catalog = this.catalogService.catalog(parameters.catalogVersion());
            CatalogIndexDescriptor indexDescriptor = catalog.index(parameters.indexId());
            assert (indexDescriptor != null) : parameters.indexId();
            if (this.localNodeIsPrimaryReplicaForTableIds.contains(indexDescriptor.tableId())) {
                this.changeIndexStatusTaskScheduler.scheduleRemoveIndexTask(indexDescriptor);
            }
        });
    }

    private void onIndexRemoved(RemoveIndexEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.changeIndexStatusTaskScheduler.stopStartBuildingTask(parameters.indexId()));
    }

    private void onTableCreated(CreateTableEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            CatalogTableDescriptor tableDescriptor = parameters.tableDescriptor();
            if (this.localNodeIsPrimaryReplicaForZoneIds.contains(tableDescriptor.zoneId())) {
                this.localNodeIsPrimaryReplicaForTableIds.add(tableDescriptor.id());
            }
        });
    }

    private void onTableDropped(DropTableEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.destructionEventsQueue.enqueue((Object)new DestroyTableEvent(parameters.catalogVersion(), parameters.tableId())));
    }

    private void onPrimaryReplicaElected(PrimaryReplicaEventParameters parameters) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            PartitionGroupId primaryReplicaId = (PartitionGroupId)parameters.groupId();
            if (primaryReplicaId.partitionId() != 0) {
                return;
            }
            if (IndexManagementUtils.isLocalNode(this.clusterService, parameters.leaseholderId())) {
                this.scheduleTasksOnPrimaryReplicaElectedBusy(primaryReplicaId);
            } else {
                this.handlePrimacyLoss(primaryReplicaId);
            }
        });
    }

    private void onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        int earliestVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
        List tablesToDestroy = this.destructionEventsQueue.drainUpTo((long)earliestVersion);
        tablesToDestroy.forEach(event -> {
            this.localNodeIsPrimaryReplicaForTableIds.remove(event.tableId());
            this.changeIndexStatusTaskScheduler.stopTasksForTable(event.tableId());
        });
    }

    private void scheduleTasksOnPrimaryReplicaElectedBusy(PartitionGroupId partitionGroupId) {
        Catalog catalog = this.catalogService.catalog(this.catalogService.latestCatalogVersion());
        IntArrayList tableIds = this.getTableIdsForPrimaryReplicaElected(catalog, partitionGroupId, id -> !this.localNodeIsPrimaryReplicaForTableIds.contains(id));
        this.localNodeIsPrimaryReplicaForTableIds.addAll((Collection<Integer>)tableIds);
        List<Integer> zoneIds = this.getZoneIdsForPrimaryReplicaElected(partitionGroupId);
        this.localNodeIsPrimaryReplicaForZoneIds.addAll(zoneIds);
        tableIds.forEach(tableId -> {
            for (CatalogIndexDescriptor indexDescriptor : catalog.indexes(tableId)) {
                switch (indexDescriptor.status()) {
                    case REGISTERED: {
                        this.changeIndexStatusTaskScheduler.scheduleStartBuildingTask(indexDescriptor);
                        break;
                    }
                    case STOPPING: {
                        this.changeIndexStatusTaskScheduler.scheduleRemoveIndexTask(indexDescriptor);
                        break;
                    }
                }
            }
        });
    }

    private void handlePrimacyLoss(PartitionGroupId partitionGroupId) {
        Catalog catalog = this.catalogService.catalog(this.catalogService.latestCatalogVersion());
        IntArrayList tableIds = this.getTableIdsForPrimaryReplicaElected(catalog, partitionGroupId, this.localNodeIsPrimaryReplicaForTableIds::contains);
        this.localNodeIsPrimaryReplicaForTableIds.removeAll((Collection<?>)tableIds);
        if (this.nodeProperties.colocationEnabled()) {
            this.localNodeIsPrimaryReplicaForZoneIds.remove(((ZonePartitionId)partitionGroupId).zoneId());
        }
        tableIds.forEach(this.changeIndexStatusTaskScheduler::stopTasksForTable);
    }

    private IntArrayList getTableIdsForPrimaryReplicaElected(Catalog catalog, PartitionGroupId partitionGroupId, IntPredicate predicate) {
        TablePartitionId tablePartitionId;
        IntArrayList tableIds = new IntArrayList();
        if (this.nodeProperties.colocationEnabled()) {
            ZonePartitionId zonePartitionId = (ZonePartitionId)partitionGroupId;
            for (CatalogTableDescriptor table : catalog.tables(zonePartitionId.zoneId())) {
                if (!predicate.test(table.id())) continue;
                tableIds.add(table.id());
            }
        } else if (partitionGroupId instanceof TablePartitionId && predicate.test((tablePartitionId = (TablePartitionId)partitionGroupId).tableId())) {
            tableIds.add(tablePartitionId.tableId());
        }
        return tableIds;
    }

    private List<Integer> getZoneIdsForPrimaryReplicaElected(PartitionGroupId partitionGroupId) {
        if (this.nodeProperties.colocationEnabled()) {
            ZonePartitionId zonePartitionId = (ZonePartitionId)partitionGroupId;
            if (!this.localNodeIsPrimaryReplicaForZoneIds.contains(zonePartitionId.zoneId())) {
                return List.of(Integer.valueOf(zonePartitionId.zoneId()));
            }
            return List.of();
        }
        return List.of();
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;

        private DestroyTableEvent(int catalogVersion, int tableId) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
        }

        int catalogVersion() {
            return this.catalogVersion;
        }

        int tableId() {
            return this.tableId;
        }
    }
}

