/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueNull
extends Value {
    public static final ValueNull INSTANCE = new ValueNull();
    static final int PRECISION = 1;
    static final int DISPLAY_SIZE = 4;

    private ValueNull() {
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return builder.append("NULL");
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_NULL;
    }

    @Override
    public int getValueType() {
        return 0;
    }

    @Override
    public int getMemory() {
        return 0;
    }

    @Override
    public String getString() {
        return null;
    }

    @Override
    public boolean getBoolean() {
        return false;
    }

    @Override
    public Date getDate() {
        return null;
    }

    @Override
    public Time getTime() {
        return null;
    }

    @Override
    public Timestamp getTimestamp() {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte getByte() {
        return 0;
    }

    @Override
    public short getShort() {
        return 0;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return null;
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public int getInt() {
        return 0;
    }

    @Override
    public long getLong() {
        return 0L;
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }

    @Override
    public Reader getReader() {
        return null;
    }

    @Override
    protected Value convertTo(int type, Mode mode, Object column, ExtTypeInfo extTypeInfo) {
        return this;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        throw DbException.throwInternalError("compare null");
    }

    @Override
    public boolean containsNull() {
        return true;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setNull(parameterIndex, 0);
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }
}

