/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.gridgain.internal.h2.store.fs.FilePath;
import org.gridgain.internal.h2.store.fs.FilePathWrapper;
import org.gridgain.internal.h2.store.fs.FileRec;
import org.gridgain.internal.h2.store.fs.Recorder;

public class FilePathRec
extends FilePathWrapper {
    private static final FilePathRec INSTANCE = new FilePathRec();
    private static Recorder recorder;
    private boolean trace;

    public static void register() {
        FilePathRec.register(INSTANCE);
    }

    public static void setRecorder(Recorder recorder) {
        FilePathRec.recorder = recorder;
    }

    @Override
    public boolean createFile() {
        this.log(2, this.name);
        return super.createFile();
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        this.log(3, this.unwrap(this.name) + ":" + suffix + ":" + inTempDir);
        return super.createTempFile(suffix, inTempDir);
    }

    @Override
    public void delete() {
        this.log(4, this.name);
        super.delete();
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        return new FileRec(this, super.open(mode), this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        this.log(5, this.name);
        return super.newOutputStream(append);
    }

    @Override
    public void moveTo(FilePath newPath, boolean atomicReplace) {
        this.log(6, this.unwrap(this.name) + ":" + this.unwrap(newPath.name));
        super.moveTo(newPath, atomicReplace);
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    void log(int op, String fileName) {
        this.log(op, fileName, null, 0L);
    }

    void log(int op, String fileName, byte[] data, long x) {
        if (recorder != null) {
            recorder.log(op, fileName, data, x);
        }
    }

    @Override
    public String getScheme() {
        return "rec";
    }
}

