/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.tx;

import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueCommitted;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueUncommitted;
import org.gridgain.internal.h2.value.VersionedValue;

abstract class TxDecisionMaker
extends MVMap.DecisionMaker<VersionedValue> {
    private final int mapId;
    private final Object key;
    final Object value;
    private final Transaction transaction;
    long undoKey;
    private long lastOperationId;
    private Transaction blockingTransaction;
    private MVMap.Decision decision;

    TxDecisionMaker(int mapId, Object key, Object value, Transaction transaction) {
        this.mapId = mapId;
        this.key = key;
        this.value = value;
        this.transaction = transaction;
    }

    @Override
    public MVMap.Decision decide(VersionedValue existingValue, VersionedValue providedValue) {
        int blockingId;
        long id;
        assert (this.decision == null);
        if (existingValue == null || (id = existingValue.getOperationId()) == 0L || this.isThisTransaction(blockingId = TransactionStore.getTransactionId(id))) {
            this.logIt(existingValue);
            this.decision = MVMap.Decision.PUT;
        } else if (this.isCommitted(blockingId)) {
            this.logIt(existingValue.getCurrentValue() == null ? null : VersionedValueCommitted.getInstance(existingValue.getCurrentValue()));
            this.decision = MVMap.Decision.PUT;
        } else if (this.getBlockingTransaction() != null) {
            this.decision = MVMap.Decision.ABORT;
        } else if (this.isRepeatedOperation(id)) {
            Object committedValue = existingValue.getCommittedValue();
            this.logIt(committedValue == null ? null : VersionedValueCommitted.getInstance(committedValue));
            this.decision = MVMap.Decision.PUT;
        } else {
            this.decision = MVMap.Decision.REPEAT;
        }
        return this.decision;
    }

    @Override
    public final void reset() {
        if (this.decision != MVMap.Decision.REPEAT) {
            this.lastOperationId = 0L;
            if (this.decision == MVMap.Decision.PUT) {
                this.transaction.logUndo();
            }
        }
        this.blockingTransaction = null;
        this.decision = null;
    }

    public final MVMap.Decision getDecision() {
        return this.decision;
    }

    final Transaction getBlockingTransaction() {
        return this.blockingTransaction;
    }

    final void logIt(VersionedValue value) {
        this.undoKey = this.transaction.log(this.mapId, this.key, value);
    }

    final boolean isThisTransaction(int transactionId) {
        return transactionId == this.transaction.transactionId;
    }

    final boolean isCommitted(int transactionId) {
        boolean result;
        Transaction blockingTx;
        do {
            blockingTx = this.transaction.store.getTransaction(transactionId);
            result = this.transaction.store.committingTransactions.get().get(transactionId);
        } while (blockingTx != this.transaction.store.getTransaction(transactionId));
        if (!result) {
            this.blockingTransaction = blockingTx;
        }
        return result;
    }

    final boolean isRepeatedOperation(long id) {
        if (id == this.lastOperationId) {
            return true;
        }
        this.lastOperationId = id;
        return false;
    }

    final MVMap.Decision setDecision(MVMap.Decision decision) {
        this.decision = decision;
        return this.decision;
    }

    public final String toString() {
        return "txdm " + this.transaction.transactionId;
    }

    public static final class LockDecisionMaker
    extends TxDecisionMaker {
        LockDecisionMaker(int mapId, Object key, Transaction transaction) {
            super(mapId, key, null, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue existingValue, VersionedValue providedValue) {
            MVMap.Decision decision = super.decide(existingValue, providedValue);
            if (existingValue == null) {
                assert (decision == MVMap.Decision.PUT);
                decision = this.setDecision(MVMap.Decision.REMOVE);
            }
            return decision;
        }

        @Override
        public VersionedValue selectValue(VersionedValue existingValue, VersionedValue providedValue) {
            return VersionedValueUncommitted.getInstance(this.undoKey, existingValue == null ? null : existingValue.getCurrentValue(), existingValue == null ? null : existingValue.getCommittedValue());
        }
    }

    public static final class PutIfAbsentDecisionMaker
    extends PutDecisionMaker {
        PutIfAbsentDecisionMaker(int mapId, Object key, Object value, Transaction transaction) {
            super(mapId, key, value, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue existingValue, VersionedValue providedValue) {
            int blockingId;
            assert (this.getDecision() == null);
            if (existingValue == null) {
                this.logIt(null);
                return this.setDecision(MVMap.Decision.PUT);
            }
            long id = existingValue.getOperationId();
            if (id == 0L || this.isThisTransaction(blockingId = TransactionStore.getTransactionId(id))) {
                if (existingValue.getCurrentValue() != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                this.logIt(existingValue);
                return this.setDecision(MVMap.Decision.PUT);
            }
            if (this.isCommitted(blockingId)) {
                if (existingValue.getCurrentValue() != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                this.logIt(null);
                return this.setDecision(MVMap.Decision.PUT);
            }
            if (this.getBlockingTransaction() != null) {
                return this.setDecision(MVMap.Decision.ABORT);
            }
            if (this.isRepeatedOperation(id)) {
                Object committedValue = existingValue.getCommittedValue();
                if (committedValue != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                this.logIt(null);
                return this.setDecision(MVMap.Decision.PUT);
            }
            return this.setDecision(MVMap.Decision.REPEAT);
        }
    }

    public static class PutDecisionMaker
    extends TxDecisionMaker {
        PutDecisionMaker(int mapId, Object key, Object value, Transaction transaction) {
            super(mapId, key, value, transaction);
        }

        @Override
        public final VersionedValue selectValue(VersionedValue existingValue, VersionedValue providedValue) {
            return VersionedValueUncommitted.getInstance(this.undoKey, this.value, existingValue == null ? null : existingValue.getCommittedValue());
        }
    }
}

