/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.function;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.function.Function;
import org.gridgain.internal.h2.expression.function.FunctionInfo;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueCollectionBase;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;

public class TableFunction
extends Function {
    private final long rowCount;
    private Column[] columns;

    TableFunction(Database database, FunctionInfo info, long rowCount) {
        super(database, info);
        this.rowCount = rowCount;
    }

    @Override
    public Value getValue(Session session) {
        return this.getTable(session, false);
    }

    @Override
    protected void checkParameterCount(int len) {
        if (len < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        if (this.info.type == 233) {
            super.getSQL(builder, alwaysQuote);
            if (this.args.length < this.columns.length) {
                builder.append(" WITH ORDINALITY");
            }
            return builder;
        }
        builder.append(this.getName()).append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.columns[i].getCreateSQL()).append('=');
            this.args[i].getSQL(builder, alwaysQuote);
        }
        return builder.append(')');
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] nullArgs) {
        return this.getTable(session, true);
    }

    public void setColumns(ArrayList<Column> columns) {
        this.columns = columns.toArray(new Column[0]);
    }

    private ValueResultSet getTable(Session session, boolean onlyColumnList) {
        int totalColumns = this.columns.length;
        Expression[] header = new Expression[totalColumns];
        Database db = session.getDatabase();
        for (int i = 0; i < totalColumns; ++i) {
            Column c = this.columns[i];
            ExpressionColumn col = new ExpressionColumn(db, c);
            header[i] = col;
        }
        LocalResult result = db.getResultFactory().create(session, header, totalColumns, true);
        if (!onlyColumnList && this.info.type == 224) {
            result.setDistinct();
        }
        if (!onlyColumnList) {
            Value[] l;
            int len = totalColumns;
            boolean unnest = this.info.type == 233;
            boolean addNumber = false;
            if (unnest && (len = this.args.length) < totalColumns) {
                addNumber = true;
            }
            Value[][] list = new Value[len][];
            int rows = 0;
            for (int i = 0; i < len; ++i) {
                Value v = this.args[i].getValue(session);
                if (v == ValueNull.INSTANCE) {
                    list[i] = new Value[0];
                    continue;
                }
                int type = v.getValueType();
                if (type != 17 && type != 39) {
                    v = v.convertTo(17);
                }
                list[i] = l = ((ValueCollectionBase)v).getList();
                rows = Math.max(rows, l.length);
            }
            for (int row = 0; row < rows; ++row) {
                Value[] r = new Value[totalColumns];
                for (int j = 0; j < len; ++j) {
                    Value v;
                    l = list[j];
                    if (l.length <= row) {
                        v = ValueNull.INSTANCE;
                    } else {
                        Column c = this.columns[j];
                        v = l[row];
                        if (!unnest) {
                            v = c.convert(v).convertPrecision(c.getType().getPrecision(), false).convertScale(true, c.getType().getScale());
                        }
                    }
                    r[j] = v;
                }
                if (addNumber) {
                    r[len] = ValueInt.get(row + 1);
                }
                result.addRow(r);
            }
        }
        result.done();
        return ValueResultSet.get(result, Integer.MAX_VALUE);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return TableFunction.getExpressionColumns(session, this.getValueForColumnList(session, null).getResult());
    }

    @Override
    public boolean isConstant() {
        for (Expression e : this.args) {
            if (e.isConstant()) continue;
            return false;
        }
        return true;
    }
}

