/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.command.ddl.CreateSynonymData;
import org.gridgain.internal.h2.command.ddl.SchemaCommand;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.TableSynonym;

public class CreateSynonym
extends SchemaCommand {
    private final CreateSynonymData data = new CreateSynonymData();
    private boolean ifNotExists;
    private boolean orReplace;
    private String comment;

    public CreateSynonym(Session session, Schema schema) {
        super(session, schema);
    }

    public void setName(String name) {
        this.data.synonymName = name;
    }

    public void setSynonymFor(String tableName) {
        this.data.synonymFor = tableName;
    }

    public void setSynonymForSchema(Schema synonymForSchema) {
        this.data.synonymForSchema = synonymForSchema;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    @Override
    public int update() {
        if (!this.transactional) {
            this.session.commit(true);
        }
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        this.data.session = this.session;
        db.lockMeta(this.session);
        if (this.getSchema().findTableOrView(this.session, this.data.synonymName) != null) {
            throw DbException.get(42101, this.data.synonymName);
        }
        if (this.data.synonymForSchema.findTableOrView(this.session, this.data.synonymFor) != null) {
            return this.createTableSynonym(db);
        }
        throw DbException.get(42102, this.data.synonymForSchema.getName() + "." + this.data.synonymFor);
    }

    private int createTableSynonym(Database db) {
        TableSynonym table;
        TableSynonym old = this.getSchema().getSynonym(this.data.synonymName);
        if (old != null && !this.orReplace) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.data.synonymName);
        }
        if (old != null) {
            table = old;
            this.data.schema = table.getSchema();
            table.updateData(this.data);
            table.setComment(this.comment);
            table.setModified();
            db.updateMeta(this.session, table);
        } else {
            this.data.id = this.getObjectId();
            table = this.getSchema().createSynonym(this.data);
            table.setComment(this.comment);
            db.addSchemaObject(this.session, table);
        }
        table.updateSynonymFor();
        return 0;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public int getType() {
        return 88;
    }
}

