/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command;

import java.util.ArrayList;
import java.util.List;
import org.gridgain.internal.h2.command.Command;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.value.Value;

public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected boolean create = true;
    protected ArrayList<Parameter> parameters;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int persistedObjectId;
    private long currentRowNumber;
    private int rowScanCount;
    private List<TableView> cteCleanups;

    public Prepared(Session session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta();

    public abstract int getType();

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() {
        Database db = this.session.getDatabase();
        if (db == null) {
            throw DbException.get(90067, "database closed");
        }
        return this.prepareAlways || this.modificationMetaId < db.getModificationMetaId() || db.getSettings().recompileAlways;
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long id) {
        this.modificationMetaId = id;
    }

    public void setParameterList(ArrayList<Parameter> parameters) {
        this.parameters = parameters;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    protected void checkParameters() {
        if (this.persistedObjectId < 0) {
            this.persistedObjectId = -this.persistedObjectId - 1;
        }
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                param.checkSet();
            }
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() {
    }

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int maxrows) {
        throw DbException.get(90002);
    }

    public void setSQL(String sql) {
        this.sqlStatement = sql;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getPersistedObjectId() {
        int id = this.persistedObjectId;
        return id >= 0 ? id : 0;
    }

    protected int getObjectId() {
        int id = this.persistedObjectId;
        if (id == 0) {
            id = this.session.getDatabase().allocateObjectId();
        } else if (id < 0) {
            throw DbException.throwInternalError("Prepared.getObjectId() was called before");
        }
        this.persistedObjectId = -this.persistedObjectId - 1;
        return id;
    }

    public String getPlanSQL(boolean alwaysQuote) {
        return null;
    }

    public void checkCanceled() {
        Command c;
        this.session.checkCanceled();
        Command command = c = this.command != null ? this.command : this.session.getCurrentCommand();
        if (c != null) {
            c.checkCanceled();
        }
    }

    public void setPersistedObjectId(int i) {
        this.persistedObjectId = i;
        this.create = false;
    }

    public void setSession(Session currentSession) {
        this.session = currentSession;
    }

    void trace(long startTimeNanos, int rowCount) {
        long deltaTimeNanos;
        if (this.session.getTrace().isInfoEnabled() && startTimeNanos > 0L) {
            deltaTimeNanos = System.nanoTime() - startTimeNanos;
            String params = Trace.formatParams(this.parameters);
            this.session.getTrace().infoSQL(this.sqlStatement, params, rowCount, deltaTimeNanos / 1000L / 1000L);
        }
        if (this.session.getDatabase().getQueryStatistics() && startTimeNanos != 0L) {
            deltaTimeNanos = System.nanoTime() - startTimeNanos;
            this.session.getDatabase().getQueryStatisticsData().update(this.toString(), deltaTimeNanos, rowCount);
        }
    }

    public void setPrepareAlways(boolean prepareAlways) {
        this.prepareAlways = prepareAlways;
    }

    public void setCurrentRowNumber(long rowNumber) {
        if ((++this.rowScanCount & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.currentRowNumber = rowNumber;
        this.setProgress();
    }

    public long getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void setProgress() {
        if ((this.currentRowNumber & 0x7FL) == 0L) {
            this.session.getDatabase().setProgress(7, this.sqlStatement, MathUtils.convertLongToInt(this.currentRowNumber), 0);
        }
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected static String getSQL(Value[] values) {
        StringBuilder builder = new StringBuilder();
        int l = values.length;
        for (int i = 0; i < l; ++i) {
            Value v;
            if (i > 0) {
                builder.append(", ");
            }
            if ((v = values[i]) == null) continue;
            v.getSQL(builder);
        }
        return builder.toString();
    }

    protected static String getSimpleSQL(Expression[] list) {
        StringBuilder builder = new StringBuilder();
        Expression.writeExpressions(builder, list, false);
        return builder.toString();
    }

    protected DbException setRow(DbException e, int rowId, String values) {
        StringBuilder buff = new StringBuilder();
        if (this.sqlStatement != null) {
            buff.append(this.sqlStatement);
        }
        buff.append(" -- ");
        if (rowId > 0) {
            buff.append("row #").append(rowId + 1).append(' ');
        }
        buff.append('(').append(values).append(')');
        return e.addSQL(buff.toString());
    }

    public boolean isCacheable() {
        return false;
    }

    public List<TableView> getCteCleanups() {
        return this.cteCleanups;
    }

    public void setCteCleanups(List<TableView> cteCleanups) {
        this.cteCleanups = cteCleanups;
    }

    public Session getSession() {
        return this.session;
    }
}

