/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueShort
extends Value {
    static final int PRECISION = 5;
    static final int DISPLAY_SIZE = 6;
    private final short value;

    private ValueShort(short value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueShort other = (ValueShort)v;
        return ValueShort.checkRange(this.value + other.value);
    }

    private static ValueShort checkRange(int x) {
        if ((short)x != x) {
            throw DbException.get(22003, Integer.toString(x));
        }
        return ValueShort.get((short)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueShort.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueShort other = (ValueShort)v;
        return ValueShort.checkRange(this.value - other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueShort other = (ValueShort)v;
        return ValueShort.checkRange(this.value * other.value);
    }

    @Override
    public Value divide(Value v) {
        ValueShort other = (ValueShort)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.checkRange(this.value / other.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueShort other = (ValueShort)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value % other.value));
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_SHORT;
    }

    @Override
    public int getValueType() {
        return 3;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Integer.compare(this.value, ((ValueShort)o).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setShort(parameterIndex, this.value);
    }

    public static ValueShort get(short i) {
        return (ValueShort)Value.cache(new ValueShort(i));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueShort && this.value == ((ValueShort)other).value;
    }
}

