/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueLong
extends Value {
    public static final ValueLong MIN = ValueLong.get(Long.MIN_VALUE);
    public static final ValueLong MAX = ValueLong.get(Long.MAX_VALUE);
    public static final BigInteger MAX_BI = BigInteger.valueOf(Long.MAX_VALUE);
    public static final int PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final int STATIC_SIZE = 100;
    private static final ValueLong[] STATIC_CACHE = new ValueLong[100];
    private final long value;

    private ValueLong(long value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        long x = this.value;
        long y = ((ValueLong)v).value;
        long result = x + y;
        if (((x ^ result) & (y ^ result)) < 0L) {
            throw this.getOverflow();
        }
        return ValueLong.get(result);
    }

    @Override
    public int getSignum() {
        return Long.signum(this.value);
    }

    @Override
    public Value negate() {
        if (this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, Long.toString(this.value));
    }

    @Override
    public Value subtract(Value v) {
        long x = this.value;
        long y = ((ValueLong)v).value;
        long result = x - y;
        if (((x ^ y) & (x ^ result)) < 0L) {
            throw this.getOverflow();
        }
        return ValueLong.get(result);
    }

    @Override
    public Value multiply(Value v) {
        long x = this.value;
        long y = ((ValueLong)v).value;
        long result = x * y;
        if ((Math.abs(x) | Math.abs(y)) >>> 31 != 0L && y != 0L && (result / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw this.getOverflow();
        }
        return ValueLong.get(result);
    }

    @Override
    public Value divide(Value v) {
        long y = ((ValueLong)v).value;
        if (y == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        long x = this.value;
        if (x == Long.MIN_VALUE && y == -1L) {
            throw this.getOverflow();
        }
        return ValueLong.get(x / y);
    }

    @Override
    public Value modulus(Value v) {
        ValueLong other = (ValueLong)v;
        if (other.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_LONG;
    }

    @Override
    public int getValueType() {
        return 5;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Long.compare(this.value, ((ValueLong)o).value);
    }

    @Override
    public String getString() {
        return Long.toString(this.value);
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setLong(parameterIndex, this.value);
    }

    public static ValueLong get(long i) {
        if (i >= 0L && i < 100L) {
            return STATIC_CACHE[(int)i];
        }
        return (ValueLong)Value.cache(new ValueLong(i));
    }

    @Override
    public int getMemory() {
        if (this.value >= 0L && this.value < 100L) {
            return 0;
        }
        return super.getMemory();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueLong && this.value == ((ValueLong)other).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueLong.STATIC_CACHE[i] = new ValueLong(i);
        }
    }
}

