/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.nio.charset.Charset;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;

public class CharsetCollator
extends Collator {
    static final Comparator<byte[]> COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] b1, byte[] b2) {
            int minLength = Math.min(b1.length, b2.length);
            for (int index = 0; index < minLength; ++index) {
                int result = b1[index] - b2[index];
                if (result == 0) continue;
                return result;
            }
            return b1.length - b2.length;
        }
    };
    private final Charset charset;

    public CharsetCollator(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int compare(String source, String target) {
        return COMPARATOR.compare(this.toBytes(source), this.toBytes(target));
    }

    byte[] toBytes(String source) {
        return source.getBytes(this.charset);
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return new CharsetCollationKey(source);
    }

    @Override
    public int hashCode() {
        return 255;
    }

    private class CharsetCollationKey
    extends CollationKey {
        CharsetCollationKey(String source) {
            super(source);
        }

        @Override
        public int compareTo(CollationKey target) {
            return COMPARATOR.compare(this.toByteArray(), CharsetCollator.this.toBytes(target.getSourceString()));
        }

        @Override
        public byte[] toByteArray() {
            return CharsetCollator.this.toBytes(this.getSourceString());
        }
    }
}

