/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.index.HashJoinIndex;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.RowList;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SimpleRow;
import org.gridgain.internal.h2.result.SimpleRowValue;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObjectBase;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.schema.TriggerObject;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.IndexHints;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableSynonym;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    protected Column[] columns;
    protected CompareMode compareMode;
    protected boolean isHidden;
    private final HashMap<String, Column> columnMap;
    private final boolean persistIndexes;
    private final boolean persistData;
    private ArrayList<TriggerObject> triggers;
    private ArrayList<Constraint> constraints;
    private ArrayList<Sequence> sequences;
    private final CopyOnWriteArrayList<TableView> dependentViews = new CopyOnWriteArrayList();
    private ArrayList<TableSynonym> synonyms;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private volatile Row nullRow;
    private boolean tableExpression;

    public Table(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        super(schema, id, name, 11);
        this.columnMap = schema.getDatabase().newStringMap();
        this.persistIndexes = persistIndexes;
        this.persistData = persistData;
        this.compareMode = schema.getDatabase().getCompareMode();
    }

    @Override
    public void rename(String newName) {
        super.rename(newName);
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                constraint.rebuild();
            }
        }
    }

    public boolean isView() {
        return false;
    }

    public abstract boolean lock(Session var1, boolean var2, boolean var3);

    public abstract void close(Session var1);

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, IndexColumn[] var4, IndexType var5, boolean var6, String var7);

    public Row getRow(Session session, long key) {
        return null;
    }

    public abstract void removeRow(Session var1, Row var2);

    public Row lockRow(Session session, Row row) {
        throw DbException.getUnsupportedException("lockRow()");
    }

    public abstract void truncate(Session var1);

    public abstract void addRow(Session var1, Row var2);

    public void updateRow(Session session, Row oldRow, Row newRow) {
        newRow.setKey(oldRow.getKey());
        this.removeRow(session, oldRow);
        this.addRow(session, newRow);
    }

    public abstract void checkSupportAlter();

    public abstract TableType getTableType();

    public abstract Index getScanIndex(Session var1);

    public Index getScanIndex(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.getScanIndex(session);
    }

    public abstract Index getUniqueIndex();

    public abstract ArrayList<Index> getIndexes();

    public Index getIndex(String indexName) {
        ArrayList<Index> indexes = this.getIndexes();
        if ("HASH_JOIN_IDX".equalsIgnoreCase(indexName)) {
            return new HashJoinIndex(this);
        }
        if (indexes != null) {
            for (Index index : indexes) {
                if (!index.getName().equals(indexName)) continue;
                return index;
            }
        }
        throw DbException.get(42112, indexName);
    }

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public abstract boolean isDeterministic();

    public abstract boolean canGetRowCount();

    public boolean canReference() {
        return true;
    }

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1);

    public abstract long getRowCountApproximation(Session var1);

    public abstract long getDiskSpaceUsed();

    public Column getRowIdColumn() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError(this.toString());
    }

    public boolean isQueryComparable() {
        return true;
    }

    public void addDependencies(HashSet<DbObject> dependencies) {
        if (dependencies.contains(this)) {
            return;
        }
        if (this.sequences != null) {
            dependencies.addAll(this.sequences);
        }
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        for (Column col : this.columns) {
            col.isEverything(visitor);
        }
        if (this.constraints != null) {
            for (Constraint c : this.constraints) {
                c.isEverything(visitor);
            }
        }
        dependencies.add(this);
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = Utils.newSmallArrayList();
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            children.addAll(indexes);
        }
        if (this.constraints != null) {
            children.addAll(this.constraints);
        }
        if (this.triggers != null) {
            children.addAll(this.triggers);
        }
        if (this.sequences != null) {
            children.addAll(this.sequences);
        }
        children.addAll(this.dependentViews);
        if (this.synonyms != null) {
            children.addAll(this.synonyms);
        }
        ArrayList<Right> rights = this.database.getAllRights();
        for (Right right : rights) {
            if (right.getGrantedObject() != this) continue;
            children.add(right);
        }
        return children;
    }

    protected void setColumns(Column[] columns) {
        this.columns = columns;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            int dataType = col.getType().getValueType();
            if (dataType == -1) {
                throw DbException.get(50004, col.getSQL(false));
            }
            col.setTable(this, i);
            String columnName = col.getName();
            if (this.columnMap.get(columnName) != null) {
                throw DbException.get(42121, columnName);
            }
            this.columnMap.put(columnName, col);
        }
        this.nullRow = null;
    }

    public void renameColumn(Column column, String newName) {
        for (Column c : this.columns) {
            if (c == column || !c.getName().equals(newName)) continue;
            throw DbException.get(42121, newName);
        }
        this.columnMap.remove(column.getName());
        column.rename(newName);
        this.columnMap.put(newName, column);
    }

    public boolean isLockedExclusivelyBy(Session session) {
        return false;
    }

    public void updateRows(Prepared prepared, Session session, RowList rows) {
        Session.Savepoint rollback = session.setSavepoint();
        int rowScanCount = 0;
        rows.reset();
        while (rows.hasNext()) {
            if ((++rowScanCount & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            Row o = rows.next();
            rows.next();
            try {
                this.removeRow(session, o);
            }
            catch (DbException e) {
                if (e.getErrorCode() == 90131 || e.getErrorCode() == 90112) {
                    session.rollbackTo(rollback);
                    session.startStatementWithinTransaction();
                    rollback = session.setSavepoint();
                }
                throw e;
            }
            session.log(this, (short)1, o);
        }
        rows.reset();
        while (rows.hasNext()) {
            if ((++rowScanCount & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            rows.next();
            Row n = rows.next();
            try {
                this.addRow(session, n);
            }
            catch (DbException e) {
                if (e.getErrorCode() == 90131) {
                    session.rollbackTo(rollback);
                    session.startStatementWithinTransaction();
                    rollback = session.setSavepoint();
                }
                throw e;
            }
            session.log(this, (short)0, n);
        }
    }

    public CopyOnWriteArrayList<TableView> getDependentViews() {
        return this.dependentViews;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        while (!this.dependentViews.isEmpty()) {
            TableView view = this.dependentViews.get(0);
            this.dependentViews.remove(0);
            this.database.removeSchemaObject(session, view);
        }
        while (this.synonyms != null && !this.synonyms.isEmpty()) {
            TableSynonym synonym = this.synonyms.remove(0);
            this.database.removeSchemaObject(session, synonym);
        }
        while (this.triggers != null && !this.triggers.isEmpty()) {
            TriggerObject trigger = this.triggers.remove(0);
            this.database.removeSchemaObject(session, trigger);
        }
        while (this.constraints != null && !this.constraints.isEmpty()) {
            Constraint constraint = this.constraints.remove(0);
            this.database.removeSchemaObject(session, constraint);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedObject() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.sequences != null && !this.sequences.isEmpty()) {
            Sequence sequence = this.sequences.remove(0);
            if (this.database.getDependentTable(sequence, this) != null) continue;
            this.database.removeSchemaObject(session, sequence);
        }
    }

    public void dropMultipleColumnsConstraintsAndIndexes(Session session, ArrayList<Column> columnsToDrop) {
        HashSet<Constraint> constraintsToDrop = new HashSet<Constraint>();
        if (this.constraints != null) {
            for (Column col : columnsToDrop) {
                for (Constraint constraint : this.constraints) {
                    HashSet<Column> columns = constraint.getReferencedColumns(this);
                    if (!columns.contains(col)) continue;
                    if (columns.size() == 1) {
                        constraintsToDrop.add(constraint);
                        continue;
                    }
                    throw DbException.get(90083, constraint.getSQL(false));
                }
            }
        }
        HashSet<Index> indexesToDrop = new HashSet<Index>();
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            for (Column col : columnsToDrop) {
                for (Index index : indexes) {
                    if (index.getCreateSQL() == null || index.getColumnIndex(col) < 0) continue;
                    if (index.getColumns().length == 1) {
                        indexesToDrop.add(index);
                        continue;
                    }
                    throw DbException.get(90083, index.getSQL(false));
                }
            }
        }
        for (Constraint c : constraintsToDrop) {
            session.getDatabase().removeSchemaObject(session, c);
        }
        for (Index i : indexesToDrop) {
            if (!this.getIndexes().contains(i)) continue;
            session.getDatabase().removeSchemaObject(session, i);
        }
    }

    public Row createRow(Value[] data, int memory) {
        return this.database.createRow(data, memory);
    }

    public Row getTemplateRow() {
        return this.createRow(new Value[this.columns.length], -1);
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        if (singleColumn) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    Row getNullRow() {
        Row row = this.nullRow;
        if (row == null) {
            Object[] values = new Value[this.columns.length];
            Arrays.fill(values, ValueNull.INSTANCE);
            this.nullRow = row = this.database.createRow((Value[])values, 1);
        }
        return row;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getType() {
        return 0;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public Column getColumn(String columnName) {
        Column column = this.columnMap.get(columnName);
        if (column == null) {
            throw DbException.get(42122, columnName);
        }
        return column;
    }

    public boolean doesColumnExist(String columnName) {
        return this.columnMap.containsKey(columnName);
    }

    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet, boolean isEquiJoined) {
        PlanItem item = new PlanItem();
        item.setIndex(this.getScanIndex(session));
        item.cost = item.getIndex().getCost(session, null, filters, filter, sortOrder, allColumnsSet);
        Trace t = session.getTrace();
        if (t.isDebugEnabled()) {
            t.debug("Table      :     potential plan item cost {0} index {1}", item.cost, item.getIndex().getPlanSQL());
        }
        ArrayList<Index> indexes = this.getIndexes() == null ? null : new ArrayList<Index>(this.getIndexes());
        IndexHints indexHints = Table.getIndexHints(filters, filter);
        if (isEquiJoined && HashJoinIndex.isApplicable(session, this)) {
            HashJoinIndex hjIdx = (HashJoinIndex)this.getIndex("HASH_JOIN_IDX");
            if (HashJoinIndex.isEnableByHint(indexHints)) {
                double cost;
                item.cost = cost = hjIdx.getCost(session, masks, filters, filter, sortOrder, allColumnsSet);
                item.setIndex(hjIdx);
                return item;
            }
            if (session.isHashJoinEnabled()) {
                indexes.add(hjIdx);
            }
        }
        if (indexes != null && masks != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                Index index = indexes.get(i);
                if (Table.isIndexExcludedByHints(indexHints, index)) continue;
                double cost = index.getCost(session, masks, filters, filter, sortOrder, allColumnsSet);
                if (t.isDebugEnabled()) {
                    t.debug("Table      :     potential plan item cost {0} index {1}", cost, index.getPlanSQL());
                }
                if (!(cost < item.cost)) continue;
                item.cost = cost;
                item.setIndex(index);
            }
        }
        return item;
    }

    private static boolean isIndexExcludedByHints(IndexHints indexHints, Index index) {
        return indexHints != null && !indexHints.allowIndex(index);
    }

    private static IndexHints getIndexHints(TableFilter[] filters, int filter) {
        return filters == null ? null : filters[filter].getIndexHints();
    }

    public Index findPrimaryKey() {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            for (Index idx : indexes) {
                if (!idx.getIndexType().isPrimaryKey()) continue;
                return idx;
            }
        }
        return null;
    }

    public Index getPrimaryKey() {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw DbException.get(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Value v2;
            Value value = row.getValue(i);
            Column column = this.columns[i];
            if (column.getComputed()) {
                value = null;
                Value value2 = column.computeValue(session, row);
            }
            if ((v2 = column.validateConvertUpdateSequence(session, value)) == value) continue;
            row.setValue(i, v2);
        }
    }

    private static void remove(ArrayList<? extends DbObject> list, DbObject obj) {
        if (list != null) {
            list.remove(obj);
        }
    }

    public void removeIndex(Index index) {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            Table.remove(indexes, index);
            if (index.getIndexType().isPrimaryKey()) {
                for (Column col : index.getColumns()) {
                    col.setPrimaryKey(false);
                }
            }
        }
    }

    public void removeDependentView(TableView view) {
        this.dependentViews.remove(view);
    }

    public void removeSynonym(TableSynonym synonym) {
        Table.remove(this.synonyms, synonym);
    }

    public void removeConstraint(Constraint constraint) {
        Table.remove(this.constraints, constraint);
    }

    public final void removeSequence(Sequence sequence) {
        Table.remove(this.sequences, sequence);
    }

    public void removeTrigger(TriggerObject trigger) {
        Table.remove(this.triggers, trigger);
    }

    public void addDependentView(TableView view) {
        this.dependentViews.add(view);
    }

    public void addSynonym(TableSynonym synonym) {
        this.synonyms = Table.add(this.synonyms, synonym);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || !this.constraints.contains(constraint)) {
            this.constraints = Table.add(this.constraints, constraint);
        }
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = Table.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject trigger) {
        this.triggers = Table.add(this.triggers, trigger);
    }

    private static <T> ArrayList<T> add(ArrayList<T> list, T obj) {
        if (list == null) {
            list = Utils.newSmallArrayList();
        }
        list.add(obj);
        return list;
    }

    public void fire(Session session, int type, boolean beforeAction) {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                trigger.fire(session, type, beforeAction);
            }
        }
    }

    public boolean hasSelectTrigger() {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                if (!trigger.isSelectTrigger()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fireRow() {
        return this.constraints != null && !this.constraints.isEmpty() || this.triggers != null && !this.triggers.isEmpty();
    }

    public boolean fireBeforeRow(Session session, Row oldRow, Row newRow) {
        boolean done = this.fireRow(session, oldRow, newRow, true, false);
        this.fireConstraints(session, oldRow, newRow, true);
        return done;
    }

    private void fireConstraints(Session session, Row oldRow, Row newRow, boolean before) {
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (constraint.isBefore() != before) continue;
                constraint.checkRow(session, this, oldRow, newRow);
            }
        }
    }

    public void fireAfterRow(Session session, Row oldRow, Row newRow, boolean rollback) {
        this.fireRow(session, oldRow, newRow, false, rollback);
        if (!rollback) {
            this.fireConstraints(session, oldRow, newRow, false);
        }
    }

    private boolean fireRow(Session session, Row oldRow, Row newRow, boolean beforeAction, boolean rollback) {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                boolean done = trigger.fireRow(session, this, oldRow, newRow, beforeAction, rollback);
                if (!done) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean enabled, boolean checkExisting) {
        if (enabled && checkExisting && this.constraints != null) {
            for (Constraint c : this.constraints) {
                c.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = enabled;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean needGetFirstOrLast, boolean needFindNext) {
        ArrayList<Index> indexes = this.getIndexes();
        Index result = null;
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                Index index = indexes.get(i);
                if (needGetFirstOrLast && !index.canGetFirstOrLast() || needFindNext && !index.canFindNext() || !index.isFirstColumn(column) || result != null && result.getColumns().length <= index.getColumns().length) continue;
                result = index;
            }
        }
        return result;
    }

    public boolean getOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean onCommitDrop) {
        this.onCommitDrop = onCommitDrop;
    }

    public boolean getOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean onCommitTruncate) {
        this.onCommitTruncate = onCommitTruncate;
    }

    public void removeIndexOrTransferOwnership(Session session, Index index) {
        boolean stillNeeded = false;
        if (this.constraints != null) {
            for (Constraint cons : this.constraints) {
                if (!cons.usesIndex(index)) continue;
                cons.setIndexOwner(index);
                this.database.updateMeta(session, cons);
                stillNeeded = true;
            }
        }
        if (!stillNeeded) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public ArrayList<Session> checkDeadlock(Session session, Session clash, Set<Session> visited) {
        return null;
    }

    public boolean isPersistIndexes() {
        return this.persistIndexes;
    }

    public boolean isPersistData() {
        return this.persistData;
    }

    public int compareValues(Value a, Value b) {
        return a.compareTo(b, this.database.getMode(), this.compareMode);
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void checkWritingAllowed() {
        this.database.checkWritingAllowed();
    }

    private static Value getGeneratedValue(Session session, Column column, Expression expression) {
        Value v = expression == null ? column.validateConvertUpdateSequence(session, null) : expression.getValue(session);
        return column.convert(v);
    }

    public Value getDefaultValue(Session session, Column column) {
        return Table.getGeneratedValue(session, column, column.getDefaultExpression());
    }

    public Value getOnUpdateValue(Session session, Column column) {
        return Table.getGeneratedValue(session, column, column.getOnUpdateExpression());
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isMVStore() {
        return false;
    }

    public void setTableExpression(boolean tableExpression) {
        this.tableExpression = tableExpression;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }

    public SearchRow getSearchRow(SearchRow row, int columnId, Value v, boolean max) {
        if (row == null) {
            row = this.getTemplateRow();
        } else {
            v = this.getMax(row.getValue(columnId), v, max);
        }
        if (columnId == -1) {
            row.setKey(v.getLong());
        } else {
            row.setValue(columnId, v);
        }
        return row;
    }

    private Value getMax(Value a, Value b, boolean bigger) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == ValueNull.INSTANCE) {
            return b;
        }
        if (b == ValueNull.INSTANCE) {
            return a;
        }
        int comp = this.database.compare(a, b);
        if (comp == 0) {
            return a;
        }
        return comp > 0 == bigger ? a : b;
    }

    public Column[] getVisibleColums() {
        ArrayList<Column> visibleCols = new ArrayList<Column>(this.columns.length);
        for (Column c : this.columns) {
            if (!c.getVisible()) continue;
            visibleCols.add(c);
        }
        return visibleCols.toArray(new Column[visibleCols.size()]);
    }
}

