/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store.fs;

import org.gridgain.internal.h2.store.fs.FilePathNioMem;

class FilePathNioMemLZF
extends FilePathNioMem {
    FilePathNioMemLZF() {
    }

    @Override
    boolean compressed() {
        return true;
    }

    @Override
    public FilePathNioMem getPath(String path) {
        if (!path.startsWith(this.getScheme())) {
            throw new IllegalArgumentException(path + " doesn't start with " + this.getScheme());
        }
        int idx1 = path.indexOf(58);
        int idx2 = path.lastIndexOf(58);
        FilePathNioMemLZF p = new FilePathNioMemLZF();
        if (idx1 != -1 && idx1 != idx2) {
            p.compressLaterCachePercent = Float.parseFloat(path.substring(idx1 + 1, idx2));
        }
        p.name = FilePathNioMemLZF.getCanonicalPath(path);
        return p;
    }

    @Override
    protected boolean isRoot() {
        return this.name.lastIndexOf(58) == this.name.length() - 1;
    }

    @Override
    public String getScheme() {
        return "nioMemLZF";
    }
}

