/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class SimpleResult
implements ResultInterface {
    private final ArrayList<Column> columns;
    private final ArrayList<Value[]> rows;
    private int rowId;

    public SimpleResult() {
        this.columns = Utils.newSmallArrayList();
        this.rows = new ArrayList();
        this.rowId = -1;
    }

    private SimpleResult(ArrayList<Column> columns, ArrayList<Value[]> rows) {
        this.columns = columns;
        this.rows = rows;
        this.rowId = -1;
    }

    public void addColumn(String alias, String columnName, int columnType, long columnPrecision, int columnScale) {
        this.addColumn(new Column(alias, columnName, columnType, columnPrecision, columnScale));
    }

    public void addColumn(String alias, String columnName, TypeInfo columnType) {
        this.addColumn(new Column(alias, columnName, columnType));
    }

    void addColumn(Column column) {
        assert (this.rows.isEmpty());
        this.columns.add(column);
    }

    public void addRow(Value ... values) {
        assert (values.length == this.columns.size());
        this.rows.add(values);
    }

    @Override
    public void reset() {
        this.rowId = -1;
    }

    @Override
    public Value[] currentRow() {
        return this.rows.get(this.rowId);
    }

    @Override
    public boolean next() {
        int count = this.rows.size();
        if (this.rowId < count) {
            return ++this.rowId < count;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rows.size();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public boolean hasNext() {
        return this.rowId < this.rows.size() - 1;
    }

    @Override
    public boolean needToClose() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public String getAlias(int i) {
        return this.columns.get((int)i).alias;
    }

    @Override
    public String getSchemaName(int i) {
        return "";
    }

    @Override
    public String getTableName(int i) {
        return "";
    }

    @Override
    public String getColumnName(int i) {
        return this.columns.get((int)i).columnName;
    }

    @Override
    public TypeInfo getColumnType(int i) {
        return this.columns.get((int)i).columnType;
    }

    @Override
    public boolean isAutoIncrement(int i) {
        return false;
    }

    @Override
    public int getNullable(int i) {
        return 2;
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public ResultInterface createShallowCopy(SessionInterface targetSession) {
        return new SimpleResult(this.columns, this.rows);
    }

    static final class Column {
        final String alias;
        final String columnName;
        final TypeInfo columnType;

        Column(String alias, String columnName, int columnType, long columnPrecision, int columnScale) {
            if (alias == null || columnName == null) {
                throw new NullPointerException();
            }
            this.alias = alias;
            this.columnName = columnName;
            this.columnType = TypeInfo.getTypeInfo(columnType, columnPrecision, columnScale, null);
        }

        Column(String alias, String columnName, TypeInfo columnType) {
            if (alias == null || columnName == null) {
                throw new NullPointerException();
            }
            this.alias = alias;
            this.columnName = columnName;
            this.columnType = columnType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alias.hashCode();
            result = 31 * result + this.columnName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Column other = (Column)obj;
            return this.alias.equals(other.alias) && this.columnName.equals(other.columnName);
        }

        public String toString() {
            if (this.alias.equals(this.columnName)) {
                return this.columnName;
            }
            return this.columnName + ' ' + this.alias;
        }
    }
}

