/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import java.io.IOException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.value.Transfer;
import org.gridgain.internal.h2.value.TypeInfo;

public class ResultColumn {
    final String alias;
    final String schemaName;
    final String tableName;
    final String columnName;
    final TypeInfo columnType;
    final boolean autoIncrement;
    final int nullable;

    ResultColumn(Transfer in) throws IOException {
        this.alias = in.readString();
        this.schemaName = in.readString();
        this.tableName = in.readString();
        this.columnName = in.readString();
        int valueType = in.readInt();
        long precision = in.readLong();
        int scale = in.readInt();
        int displaySize = in.readInt();
        this.columnType = new TypeInfo(valueType, precision, scale, displaySize, null);
        this.autoIncrement = in.readBoolean();
        this.nullable = in.readInt();
    }

    public static void writeColumn(Transfer out, ResultInterface result, int i) throws IOException {
        out.writeString(result.getAlias(i));
        out.writeString(result.getSchemaName(i));
        out.writeString(result.getTableName(i));
        out.writeString(result.getColumnName(i));
        TypeInfo type = result.getColumnType(i);
        out.writeInt(type.getValueType());
        out.writeLong(type.getPrecision());
        out.writeInt(type.getScale());
        out.writeInt(type.getDisplaySize());
        out.writeBoolean(result.isAutoIncrement(i));
        out.writeInt(result.getNullable(i));
    }
}

