/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.PageDataLeaf;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

class PageDataCursor
implements Cursor {
    private PageDataLeaf current;
    private int idx;
    private final long maxKey;
    private Row row;

    PageDataCursor(PageDataLeaf current, int idx, long maxKey) {
        this.current = current;
        this.idx = idx;
        this.maxKey = maxKey;
    }

    @Override
    public Row get() {
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        this.nextRow();
        return this.checkMax();
    }

    private boolean checkMax() {
        if (this.row != null) {
            long x;
            if (this.maxKey != Long.MAX_VALUE && (x = this.current.index.getKey(this.row, Long.MAX_VALUE, Long.MAX_VALUE)) > this.maxKey) {
                this.row = null;
                return false;
            }
            return true;
        }
        return false;
    }

    private void nextRow() {
        if (this.idx >= this.current.getEntryCount()) {
            this.current = this.current.getNextPage();
            this.idx = 0;
            if (this.current == null) {
                this.row = null;
                return;
            }
        }
        this.row = this.current.getRowAt(this.idx);
        ++this.idx;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

