/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.LinkedCursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableLink;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class LinkedIndex
extends BaseIndex {
    private final TableLink link;
    private final String targetTableName;
    private long rowCount;
    private final boolean quoteAllIdentifiers = false;

    public LinkedIndex(TableLink table, int id, IndexColumn[] columns, IndexType indexType) {
        super(table, id, null, columns, indexType);
        this.link = table;
        this.targetTableName = this.link.getQualifiedTable();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    private static boolean isNull(Value v) {
        return v == null || v == ValueNull.INSTANCE;
    }

    @Override
    public void add(Session session, Row row) {
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder buff = new StringBuilder("INSERT INTO ");
        buff.append(this.targetTableName).append(" VALUES(");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            Value v = row.getValue(i);
            if (i > 0) {
                buff.append(", ");
            }
            if (v == null) {
                buff.append("DEFAULT");
                continue;
            }
            if (LinkedIndex.isNull(v)) {
                buff.append("NULL");
                continue;
            }
            buff.append('?');
            params.add(v);
        }
        buff.append(')');
        String sql = buff.toString();
        try {
            this.link.execute(sql, params, true);
            ++this.rowCount;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        Column col;
        Value v;
        int i;
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder builder = new StringBuilder("SELECT * FROM ").append(this.targetTableName).append(" T");
        boolean f = false;
        for (i = 0; first != null && i < first.getColumnCount(); ++i) {
            v = first.getValue(i);
            if (v == null) continue;
            builder.append(f ? " AND " : " WHERE ");
            f = true;
            col = this.table.getColumn(i);
            col.getSQL(builder, false);
            if (v == ValueNull.INSTANCE) {
                builder.append(" IS NULL");
                continue;
            }
            builder.append(">=");
            this.addParameter(builder, col);
            params.add(v);
        }
        for (i = 0; last != null && i < last.getColumnCount(); ++i) {
            v = last.getValue(i);
            if (v == null) continue;
            builder.append(f ? " AND " : " WHERE ");
            f = true;
            col = this.table.getColumn(i);
            col.getSQL(builder, false);
            if (v == ValueNull.INSTANCE) {
                builder.append(" IS NULL");
                continue;
            }
            builder.append("<=");
            this.addParameter(builder, col);
            params.add(v);
        }
        String sql = builder.toString();
        try {
            PreparedStatement prep = this.link.execute(sql, params, false);
            ResultSet rs = prep.getResultSet();
            return new LinkedCursor(this.link, rs, session, sql, prep);
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    private void addParameter(StringBuilder builder, Column col) {
        TypeInfo type = col.getType();
        if (type.getValueType() == 21 && this.link.isOracle()) {
            builder.append("CAST(? AS CHAR(").append(type.getPrecision()).append("))");
        } else {
            builder.append('?');
        }
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 100L + this.getCostRangeIndex(masks, this.rowCount + 1000L, filters, filter, sortOrder, false, allColumnsSet);
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("LINKED");
    }

    @Override
    public void remove(Session session, Row row) {
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder builder = new StringBuilder("DELETE FROM ").append(this.targetTableName).append(" WHERE ");
        for (int i = 0; i < row.getColumnCount(); ++i) {
            if (i > 0) {
                builder.append("AND ");
            }
            Column col = this.table.getColumn(i);
            col.getSQL(builder, false);
            Value v = row.getValue(i);
            if (LinkedIndex.isNull(v)) {
                builder.append(" IS NULL ");
                continue;
            }
            builder.append('=');
            this.addParameter(builder, col);
            params.add(v);
            builder.append(' ');
        }
        String sql = builder.toString();
        try {
            PreparedStatement prep = this.link.execute(sql, params, false);
            int count = prep.executeUpdate();
            this.link.reusePreparedStatement(prep, sql);
            this.rowCount -= (long)count;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    public void update(Row oldRow, Row newRow) {
        int i;
        ArrayList<Value> params = Utils.newSmallArrayList();
        StringBuilder builder = new StringBuilder("UPDATE ").append(this.targetTableName).append(" SET ");
        for (i = 0; i < newRow.getColumnCount(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.table.getColumn(i).getSQL(builder, false).append('=');
            Value v = newRow.getValue(i);
            if (v == null) {
                builder.append("DEFAULT");
                continue;
            }
            builder.append('?');
            params.add(v);
        }
        builder.append(" WHERE ");
        for (i = 0; i < oldRow.getColumnCount(); ++i) {
            Column col = this.table.getColumn(i);
            if (i > 0) {
                builder.append(" AND ");
            }
            col.getSQL(builder, false);
            Value v = oldRow.getValue(i);
            if (LinkedIndex.isNull(v)) {
                builder.append(" IS NULL");
                continue;
            }
            builder.append('=');
            params.add(v);
            this.addParameter(builder, col);
        }
        String sql = builder.toString();
        try {
            this.link.execute(sql, params, true);
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

