/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.engine.Procedure;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.util.Utils;

public class ExecuteProcedure
extends Prepared {
    private final ArrayList<Expression> expressions = Utils.newSmallArrayList();
    private Procedure procedure;

    public ExecuteProcedure(Session session) {
        super(session);
    }

    public void setProcedure(Procedure procedure) {
        this.procedure = procedure;
    }

    public void setExpression(int index, Expression expr) {
        this.expressions.add(index, expr);
    }

    private void setParameters() {
        Prepared prepared = this.procedure.getPrepared();
        ArrayList<Parameter> params = prepared.getParameters();
        for (int i = 0; params != null && i < params.size() && i < this.expressions.size(); ++i) {
            Expression expr = this.expressions.get(i);
            Parameter p = params.get(i);
            p.setValue(expr.getValue(this.session));
        }
    }

    @Override
    public boolean isQuery() {
        Prepared prepared = this.procedure.getPrepared();
        return prepared.isQuery();
    }

    @Override
    public int update() {
        this.setParameters();
        Prepared prepared = this.procedure.getPrepared();
        return prepared.update();
    }

    @Override
    public ResultInterface query(int limit) {
        this.setParameters();
        Prepared prepared = this.procedure.getPrepared();
        return prepared.query(limit);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        Prepared prepared = this.procedure.getPrepared();
        return prepared.queryMeta();
    }

    @Override
    public int getType() {
        return 59;
    }
}

