/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.HashSet;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.RowList;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private Expression limitExpr;
    private TableFilter sourceTableFilter;
    private HashSet<Long> keysFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setKeysFilter(HashSet<Long> keysFilter) {
        this.keysFilter = keysFilter;
    }

    @Override
    public int update() {
        Value v;
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fire(this.session, 4, true);
        table.lock(this.session, true, false);
        int limitRows = -1;
        if (this.limitExpr != null && (v = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            limitRows = v.getInt();
        }
        try (RowList rows = new RowList(this.session);){
            Row row;
            this.setCurrentRowNumber(0L);
            int count = 0;
            while (limitRows != 0 && this.targetTableFilter.next()) {
                this.setCurrentRowNumber(rows.size() + 1);
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                Row row2 = this.targetTableFilter.get();
                if (this.keysFilter != null && !this.keysFilter.contains(row2.getKey())) continue;
                if (table.isMVStore()) {
                    Row lockedRow = table.lockRow(this.session, row2);
                    if (lockedRow == null) continue;
                    if (!row2.hasSharedData(lockedRow)) {
                        row2 = lockedRow;
                        this.targetTableFilter.set(row2);
                        if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                    }
                }
                if (!table.fireRow() || !table.fireBeforeRow(this.session, row2, null)) {
                    rows.add(row2);
                }
                if (limitRows < 0 || ++count < limitRows) continue;
                break;
            }
            int rowScanCount = 0;
            rows.reset();
            while (rows.hasNext()) {
                if ((++rowScanCount & 0x7F) == 0) {
                    this.checkCanceled();
                }
                row = rows.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rows.reset();
                while (rows.hasNext()) {
                    row = rows.next();
                    table.fireAfterRow(this.session, row, null, false);
                }
            }
            table.fire(this.session, 4, false);
            int n = count;
            return n;
        }
    }

    @Override
    public String getPlanSQL(boolean alwaysQuote) {
        StringBuilder buff = new StringBuilder();
        buff.append("DELETE FROM ");
        this.targetTableFilter.getPlanSQL(buff, false, alwaysQuote);
        if (this.condition != null) {
            buff.append("\nWHERE ");
            this.condition.getUnenclosedSQL(buff, alwaysQuote);
        }
        if (this.limitExpr != null) {
            buff.append("\nLIMIT (");
            this.limitExpr.getUnenclosedSQL(buff, alwaysQuote).append(')');
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0, 0);
            if (this.sourceTableFilter != null) {
                this.condition.mapColumns(this.sourceTableFilter, 0, 0);
            }
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        TableFilter[] filters = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem item = this.targetTableFilter.getBestPlanItem(this.session, filters, 0, new AllColumnsForPlan(filters));
        this.targetTableFilter.setPlanItem(item);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 58;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public void setSourceTableFilter(TableFilter sourceTableFilter) {
        this.sourceTableFilter = sourceTableFilter;
    }

    public TableFilter getTableFilter() {
        return this.targetTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }
}

