/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;

public class Analyze
extends DefineCommand {
    private int sampleRows;
    private Table table;

    public Analyze(Session session) {
        super(session);
        this.sampleRows = session.getDatabase().getSettings().analyzeSample;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        if (this.table != null) {
            Analyze.analyzeTable(this.session, this.table, this.sampleRows, true);
        } else {
            for (Table table : db.getAllTablesAndViews(false)) {
                Analyze.analyzeTable(this.session, table, this.sampleRows, true);
            }
        }
        return 0;
    }

    public static void analyzeTable(Session session, Table table, int sample, boolean manual) {
        if (table.getTableType() != TableType.TABLE || table.isHidden() || session == null) {
            return;
        }
        if (!manual) {
            if (session.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session)) {
            return;
        }
        if (!session.getUser().hasRight(table, 1)) {
            return;
        }
        if (session.getCancel() != 0L) {
            return;
        }
        Column[] columns = table.getColumns();
        if (columns.length == 0) {
            return;
        }
        Database db = session.getDatabase();
        StringBuilder buff = new StringBuilder("SELECT ");
        int l = columns.length;
        for (int i = 0; i < l; ++i) {
            Column col;
            if (i > 0) {
                buff.append(", ");
            }
            if (DataType.isLargeObject((col = columns[i]).getType().getValueType())) {
                buff.append("MAX(NULL)");
                continue;
            }
            buff.append("SELECTIVITY(");
            col.getSQL(buff, true).append(')');
        }
        buff.append(" FROM ");
        table.getSQL(buff, true);
        if (sample > 0) {
            buff.append(" FETCH FIRST ROW ONLY SAMPLE_SIZE ? ");
        }
        String sql = buff.toString();
        Prepared command = session.prepare(sql);
        if (sample > 0) {
            ArrayList<Parameter> params = command.getParameters();
            params.get(0).setValue(ValueInt.get(sample));
        }
        ResultInterface result = command.query(0);
        result.next();
        for (int j = 0; j < columns.length; ++j) {
            Value v = result.currentRow()[j];
            if (v == ValueNull.INSTANCE) continue;
            int selectivity = v.getInt();
            columns[j].setSelectivity(selectivity);
        }
        db.updateMeta(session, table);
    }

    public void setTop(int top) {
        this.sampleRows = top;
    }

    @Override
    public int getType() {
        return 21;
    }
}

