/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.tools.SimpleResultSet;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.StringUtils;

public class LinkSchema {
    private LinkSchema() {
    }

    public static ResultSet linkSchema(Connection conn, String targetSchema, String driver, String url, String user, String password, String sourceSchema) {
        Connection c2 = null;
        Statement stat = null;
        ResultSet rs = null;
        SimpleResultSet result = new SimpleResultSet();
        result.setAutoClose(false);
        result.addColumn("TABLE_NAME", 12, Integer.MAX_VALUE, 0);
        try {
            c2 = JdbcUtils.getConnection(driver, url, user, password);
            stat = conn.createStatement();
            stat.execute(StringUtils.quoteIdentifier(new StringBuilder("CREATE SCHEMA IF NOT EXISTS "), targetSchema).toString());
            rs = url.startsWith("jdbc:postgresql:") ? c2.getMetaData().getTables(null, sourceSchema, null, new String[]{"TABLE", "LINKED TABLE", "VIEW", "EXTERNAL"}) : c2.getMetaData().getTables(null, sourceSchema, null, null);
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                StringBuilder buff = new StringBuilder();
                buff.append("DROP TABLE IF EXISTS ");
                StringUtils.quoteIdentifier(buff, targetSchema).append('.');
                StringUtils.quoteIdentifier(buff, table);
                stat.execute(buff.toString());
                buff.setLength(0);
                buff.append("CREATE LINKED TABLE ");
                StringUtils.quoteIdentifier(buff, targetSchema).append('.');
                StringUtils.quoteIdentifier(buff, table).append('(');
                StringUtils.quoteStringSQL(buff, driver).append(", ");
                StringUtils.quoteStringSQL(buff, url).append(", ");
                StringUtils.quoteStringSQL(buff, user).append(", ");
                StringUtils.quoteStringSQL(buff, password).append(", ");
                StringUtils.quoteStringSQL(buff, sourceSchema).append(", ");
                StringUtils.quoteStringSQL(buff, table).append(')');
                stat.execute(buff.toString());
                result.addRow(table);
            }
        }
        catch (SQLException e) {
            try {
                throw DbException.convert(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(rs);
                JdbcUtils.closeSilently(c2);
                JdbcUtils.closeSilently(stat);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(rs);
        JdbcUtils.closeSilently(c2);
        JdbcUtils.closeSilently(stat);
        return result;
    }
}

