/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.Objects;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.ddl.SequenceOptions;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.SequenceValue;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.ConditionAndOr;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.table.SingleColumnResolver;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueUuid;

public class Column {
    public static final String ROWID = "_ROWID_";
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private final TypeInfo type;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private Expression checkConstraint;
    private String checkConstraintSQL;
    private String originalSQL;
    private SequenceOptions autoIncrementOptions;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;
    private SingleColumnResolver resolver;
    private String comment;
    private boolean primaryKey;
    private boolean visible = true;
    private boolean rowId;
    private Domain domain;

    public static StringBuilder writeColumns(StringBuilder builder, Column[] columns, boolean alwaysQuote) {
        int l = columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            columns[i].getSQL(builder, alwaysQuote);
        }
        return builder;
    }

    public static StringBuilder writeColumns(StringBuilder builder, Column[] columns, String separator, String suffix, boolean alwaysQuote) {
        int l = columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            columns[i].getSQL(builder, alwaysQuote).append(suffix);
        }
        return builder;
    }

    public Column(String name, int valueType) {
        this(name, TypeInfo.getTypeInfo(valueType));
    }

    public Column(String name, TypeInfo type) {
        this.name = name;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (this.table == null || other.table == null || this.name == null || other.name == null) {
            return false;
        }
        if (this.table != other.table) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public Column getClone() {
        Column newColumn = new Column(this.name, this.type);
        newColumn.copy(this);
        return newColumn;
    }

    public Value convert(Value v) {
        return this.convert(v, null);
    }

    public Value convert(Value v, Mode mode) {
        try {
            return v.convertTo(this.type, mode, this);
        }
        catch (DbException e) {
            if (e.getErrorCode() == 22018) {
                String target = (this.table == null ? "" : this.table.getName() + ": ") + this.getCreateSQL();
                throw DbException.get(22018, e, v.getTraceSQL() + " (" + target + ")");
            }
            throw e;
        }
    }

    boolean getComputed() {
        return this.isComputed;
    }

    synchronized Value computeValue(Session session, Row row) {
        this.computeTableFilter.setSession(session);
        this.computeTableFilter.set(row);
        return this.defaultExpression.getValue(session);
    }

    public void setComputedExpression(Expression expression) {
        this.isComputed = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table, int columnId) {
        this.table = table;
        this.columnId = columnId;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression defaultExpression) {
        if (defaultExpression != null && (defaultExpression = defaultExpression.optimize(session)).isConstant()) {
            defaultExpression = ValueExpression.get(defaultExpression.getValue(session));
        }
        this.defaultExpression = defaultExpression;
    }

    public void setOnUpdateExpression(Session session, Expression onUpdateExpression) {
        if (onUpdateExpression != null && (onUpdateExpression = onUpdateExpression.optimize(session)).isConstant()) {
            onUpdateExpression = ValueExpression.get(onUpdateExpression.getValue(session));
        }
        this.onUpdateExpression = onUpdateExpression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL(boolean alwaysQuote) {
        return this.rowId ? this.name : Parser.quoteIdentifier(this.name, alwaysQuote);
    }

    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        return this.rowId ? builder.append(this.name) : Parser.quoteIdentifier(builder, this.name, alwaysQuote);
    }

    public String getName() {
        return this.name;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setNullable(boolean b) {
        this.nullable = b;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isRowId() {
        return this.rowId;
    }

    public void setRowId(boolean rowId) {
        this.rowId = rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value) {
        Expression localDefaultExpression;
        Column column = this;
        synchronized (column) {
            localDefaultExpression = this.defaultExpression;
        }
        Mode mode = session.getDatabase().getMode();
        if (value == null) {
            if (localDefaultExpression == null) {
                value = ValueNull.INSTANCE;
            } else {
                value = this.convert(localDefaultExpression.getValue(session), mode);
                if (!localDefaultExpression.isConstant()) {
                    session.getGeneratedKeys().add(this);
                }
                if (this.primaryKey) {
                    session.setLastIdentity(value);
                }
            }
        }
        if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value = this.convert(localDefaultExpression.getValue(session), mode);
                if (!localDefaultExpression.isConstant()) {
                    session.getGeneratedKeys().add(this);
                }
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                if (mode.convertInsertNullToZero) {
                    int t = this.type.getValueType();
                    DataType dt = DataType.getDataType(t);
                    value = dt.decimal ? ValueInt.get(0).convertTo(t) : (dt.type == 11 ? session.getCurrentCommandStart().convertTo(11) : (dt.type == 24 ? session.getCurrentCommandStart() : (dt.type == 9 ? ValueTime.fromNanos(0L) : (dt.type == 10 ? session.getCurrentCommandStart().convertTo(10) : ValueString.get("").convertTo(t)))));
                } else {
                    throw DbException.get(23502, this.name);
                }
            }
        }
        if (this.checkConstraint != null) {
            Value v;
            this.resolver.setValue(value);
            Column column2 = this;
            synchronized (column2) {
                v = this.checkConstraint.getValue(session);
            }
            if (v != ValueNull.INSTANCE && !v.getBoolean()) {
                throw DbException.get(23513, this.checkConstraint.getSQL(false));
            }
        }
        value = value.convertScale(mode.convertOnlyToSmallerScale, this.type.getScale());
        long precision = this.type.getPrecision();
        if (precision > 0L && !value.checkPrecision(precision)) {
            String s = value.getTraceSQL();
            if (s.length() > 127) {
                s = s.substring(0, 128) + "...";
            }
            throw DbException.get(22001, this.getCreateSQL(), s + " (" + value.getType().getPrecision() + ')');
        }
        if (value != ValueNull.INSTANCE && DataType.isExtInfoType(this.type.getValueType()) && this.type.getExtTypeInfo() != null) {
            value = this.type.getExtTypeInfo().cast(value);
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private void updateSequenceIfRequired(Session session, Value value) {
        if (this.sequence != null) {
            long current = this.sequence.getCurrentValue();
            long inc = this.sequence.getIncrement();
            long now = value.getLong();
            boolean update = false;
            if (inc > 0L && now > current) {
                update = true;
            } else if (inc < 0L && now < current) {
                update = true;
            }
            if (update) {
                this.sequence.modify(now + inc, null, null, null);
                session.setLastIdentity(ValueLong.get(now));
                this.sequence.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int id, boolean temporary) {
        String s;
        String sequenceName;
        if (this.autoIncrementOptions == null) {
            DbException.throwInternalError();
        }
        if ("IDENTITY".equals(this.originalSQL)) {
            this.originalSQL = "BIGINT";
        } else if ("SERIAL".equals(this.originalSQL)) {
            this.originalSQL = "INT";
        }
        do {
            ValueUuid uuid = ValueUuid.getNewRandom();
            s = uuid.getString();
            s = StringUtils.toUpperEnglish(s.replace('-', '_'));
        } while (schema.findSequence(sequenceName = "SYSTEM_SEQUENCE_" + s) != null);
        Sequence seq = new Sequence(schema, id, sequenceName, this.autoIncrementOptions.getStartValue(session), this.autoIncrementOptions.getIncrement(session), this.autoIncrementOptions.getCacheSize(session), this.autoIncrementOptions.getMinValue(null, session), this.autoIncrementOptions.getMaxValue(null, session), Boolean.TRUE.equals(this.autoIncrementOptions.getCycle()), true);
        seq.setTemporary(temporary);
        session.getDatabase().addSchemaObject(session, seq);
        this.setAutoIncrementOptions(null);
        SequenceValue seqValue = new SequenceValue(seq);
        this.setDefaultExpression(session, seqValue);
        this.setSequence(seq);
    }

    public void prepareExpression(Session session) {
        if (this.defaultExpression != null || this.onUpdateExpression != null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false, null, 0, null);
            if (this.defaultExpression != null) {
                this.defaultExpression.mapColumns(this.computeTableFilter, 0, 0);
                this.defaultExpression = this.defaultExpression.optimize(session);
            }
            if (this.onUpdateExpression != null) {
                this.onUpdateExpression.mapColumns(this.computeTableFilter, 0, 0);
                this.onUpdateExpression = this.onUpdateExpression.optimize(session);
            }
        }
    }

    public String getCreateSQLWithoutName() {
        return this.getCreateSQL(false);
    }

    public String getCreateSQL() {
        return this.getCreateSQL(true);
    }

    private String getCreateSQL(boolean includeName) {
        StringBuilder buff = new StringBuilder();
        if (includeName && this.name != null) {
            Parser.quoteIdentifier(buff, this.name, true).append(' ');
        }
        if (this.originalSQL != null) {
            buff.append(this.originalSQL);
        } else {
            this.type.getSQL(buff);
        }
        if (!this.visible) {
            buff.append(" INVISIBLE ");
        }
        if (this.defaultExpression != null) {
            if (this.isComputed) {
                buff.append(" AS ");
                this.defaultExpression.getSQL(buff, true);
            } else if (this.defaultExpression != null) {
                buff.append(" DEFAULT ");
                this.defaultExpression.getSQL(buff, true);
            }
        }
        if (this.onUpdateExpression != null) {
            buff.append(" ON UPDATE ");
            this.onUpdateExpression.getSQL(buff, true);
        }
        if (!this.nullable) {
            buff.append(" NOT NULL");
        } else if (this.domain != null && !this.domain.getColumn().isNullable()) {
            buff.append(" NULL");
        }
        if (this.convertNullToDefault) {
            buff.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            buff.append(" SEQUENCE ");
            this.sequence.getSQL(buff, true);
        }
        if (this.selectivity != 0) {
            buff.append(" SELECTIVITY ").append(this.selectivity);
        }
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        if (this.checkConstraint != null) {
            buff.append(" CHECK ").append(this.checkConstraintSQL);
        }
        return buff.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String original) {
        this.originalSQL = original;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrementOptions != null;
    }

    public void setAutoIncrementOptions(SequenceOptions sequenceOptions) {
        this.autoIncrementOptions = sequenceOptions;
        this.nullable = false;
        if (sequenceOptions != null) {
            this.convertNullToDefault = true;
        }
    }

    public void setConvertNullToDefault(boolean convert) {
        this.convertNullToDefault = convert;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int selectivity) {
        this.selectivity = selectivity = selectivity < 0 ? 0 : (selectivity > 100 ? 100 : selectivity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expr) {
        if (expr == null) {
            return;
        }
        if (this.resolver == null) {
            this.resolver = new SingleColumnResolver(this);
        }
        Column column = this;
        synchronized (column) {
            String oldName = this.name;
            if (this.name == null) {
                this.name = "VALUE";
            }
            expr.mapColumns(this.resolver, 0, 0);
            this.name = oldName;
        }
        expr = expr.optimize(session);
        this.resolver.setValue(ValueNull.INSTANCE);
        column = this;
        synchronized (column) {
            expr.getValue(session);
        }
        if (this.checkConstraint == null) {
            this.checkConstraint = expr;
        } else if (!expr.getSQL(true).equals(this.checkConstraintSQL)) {
            this.checkConstraint = new ConditionAndOr(0, this.checkConstraint, expr);
        }
        this.checkConstraintSQL = this.getCheckConstraintSQL(session, this.name);
    }

    public void removeCheckConstraint() {
        this.checkConstraint = null;
        this.checkConstraintSQL = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String asColumnName) {
        String sql;
        if (this.checkConstraint == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Column column = this;
        synchronized (column) {
            String oldName = this.name;
            this.name = asColumnName;
            sql = this.checkConstraint.getSQL(true);
            this.name = oldName;
        }
        return parser.parseExpression(sql);
    }

    String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getSQL(true);
    }

    String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getSQL(true);
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.type.getPrecision());
    }

    DataType getDataType() {
        return DataType.getDataType(this.type.getValueType());
    }

    String getCheckConstraintSQL(Session session, String asColumnName) {
        Expression constraint = this.getCheckConstraint(session, asColumnName);
        return constraint == null ? "" : constraint.getSQL(true);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.getType() == 7 && this.sequence != null) {
            visitor.getDependencies().add(this.sequence);
        }
        if (this.defaultExpression != null && !this.defaultExpression.isEverything(visitor)) {
            return false;
        }
        return this.checkConstraint == null || this.checkConstraint.isEverything(visitor);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWideningConversion(Column newColumn) {
        if (this.type != newColumn.type) {
            return false;
        }
        if (this.type.getPrecision() > newColumn.type.getPrecision()) {
            return false;
        }
        if (this.type.getScale() != newColumn.type.getScale()) {
            return false;
        }
        if (this.nullable && !newColumn.nullable) {
            return false;
        }
        if (this.convertNullToDefault != newColumn.convertNullToDefault) {
            return false;
        }
        if (this.primaryKey != newColumn.primaryKey) {
            return false;
        }
        if (this.autoIncrementOptions != null || newColumn.autoIncrementOptions != null) {
            return false;
        }
        if (this.checkConstraint != null || newColumn.checkConstraint != null) {
            return false;
        }
        if (this.convertNullToDefault || newColumn.convertNullToDefault) {
            return false;
        }
        if (this.defaultExpression != null || newColumn.defaultExpression != null) {
            return false;
        }
        if (this.isComputed || newColumn.isComputed) {
            return false;
        }
        if (this.onUpdateExpression != null || newColumn.onUpdateExpression != null) {
            return false;
        }
        return Objects.equals(this.type.getExtTypeInfo(), newColumn.type.getExtTypeInfo());
    }

    public void copy(Column source) {
        this.checkConstraint = source.checkConstraint;
        this.checkConstraintSQL = source.checkConstraintSQL;
        this.name = source.name;
        this.nullable = source.nullable;
        this.defaultExpression = source.defaultExpression;
        this.onUpdateExpression = source.onUpdateExpression;
        this.originalSQL = source.originalSQL;
        this.convertNullToDefault = source.convertNullToDefault;
        this.sequence = source.sequence;
        this.comment = source.comment;
        this.computeTableFilter = source.computeTableFilter;
        this.isComputed = source.isComputed;
        this.selectivity = source.selectivity;
        this.primaryKey = source.primaryKey;
        this.visible = source.visible;
    }
}

