/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store;

import java.util.BitSet;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.Page;
import org.gridgain.internal.h2.store.PageStore;

public class PageFreeList
extends Page {
    private static final int DATA_START = 3;
    private final PageStore store;
    private final BitSet used;
    private final int pageCount;
    private boolean full;
    private Data data;

    private PageFreeList(PageStore store, int pageId, int pageCount, BitSet used) {
        this.setPos(pageId);
        this.store = store;
        this.pageCount = pageCount;
        this.used = used;
    }

    static PageFreeList read(PageStore store, Data data, int pageId) {
        data.reset();
        data.readByte();
        data.readShortInt();
        int length = store.getPageSize() - 3;
        byte[] b = new byte[length];
        data.read(b, 0, b.length);
        PageFreeList p = new PageFreeList(store, pageId, length * 8, BitSet.valueOf(b));
        p.data = data;
        p.full = false;
        return p;
    }

    static PageFreeList create(PageStore store, int pageId) {
        int pageCount = (store.getPageSize() - 3) * 8;
        BitSet used = new BitSet(pageCount);
        used.set(0);
        return new PageFreeList(store, pageId, pageCount, used);
    }

    int allocate(BitSet exclude, int first) {
        int free;
        block4: {
            if (this.full) {
                return -1;
            }
            int start = Math.max(0, first - this.getPos());
            do {
                if ((free = this.used.nextClearBit(start)) >= this.pageCount) {
                    if (start == 0) {
                        this.full = true;
                    }
                    return -1;
                }
                if (exclude == null || !exclude.get(free + this.getPos())) break block4;
            } while ((start = exclude.nextClearBit(free + this.getPos()) - this.getPos()) < this.pageCount);
            return -1;
        }
        this.used.set(free);
        this.store.logUndo(this, this.data);
        this.store.update(this);
        return free + this.getPos();
    }

    int getFirstFree(int first) {
        if (this.full) {
            return -1;
        }
        int start = Math.max(0, first - this.getPos());
        int free = this.used.nextClearBit(start);
        if (free >= this.pageCount) {
            return -1;
        }
        return free + this.getPos();
    }

    int getLastUsed() {
        int last = this.used.length() - 1;
        return last <= 0 ? -1 : last + this.getPos();
    }

    void allocate(int pageId) {
        int idx = pageId - this.getPos();
        if (idx >= 0 && !this.used.get(idx)) {
            this.used.set(idx);
            this.store.logUndo(this, this.data);
            this.store.update(this);
        }
    }

    void free(int pageId) {
        this.full = false;
        this.store.logUndo(this, this.data);
        this.used.clear(pageId - this.getPos());
        this.store.update(this);
    }

    @Override
    public void write() {
        this.data = this.store.createData();
        this.data.writeByte((byte)6);
        this.data.writeShortInt(0);
        int cnt = this.pageCount >>> 3;
        byte[] b = this.used.toByteArray();
        int l = Math.min(b.length, cnt);
        this.data.write(b, 0, l);
        for (int i = cnt - l; i > 0; --i) {
            this.data.writeByte((byte)0);
        }
        this.store.writePage(this.getPos(), this.data);
    }

    public static int getPagesAddressed(int pageSize) {
        return (pageSize - 3) * 8;
    }

    @Override
    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    boolean isUsed(int pageId) {
        return this.used.get(pageId - this.getPos());
    }

    @Override
    public void moveTo(Session session, int newPos) {
        this.store.free(this.getPos(), false);
    }

    public String toString() {
        return "page [" + this.getPos() + "] freeList" + (this.full ? "full" : "");
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean canMove() {
        return false;
    }
}

