/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.gridgain.internal.h2.mvstore.DataUtils;

public class StreamStore {
    private final Map<Long, byte[]> map;
    private int minBlockSize = 256;
    private int maxBlockSize = 262144;
    private final AtomicLong nextKey = new AtomicLong();
    private final AtomicReference<byte[]> nextBuffer = new AtomicReference();

    public StreamStore(Map<Long, byte[]> map) {
        this.map = map;
    }

    public Map<Long, byte[]> getMap() {
        return this.map;
    }

    public void setNextKey(long nextKey) {
        this.nextKey.set(nextKey);
    }

    public long getNextKey() {
        return this.nextKey.get();
    }

    public void setMinBlockSize(int minBlockSize) {
        this.minBlockSize = minBlockSize;
    }

    public int getMinBlockSize() {
        return this.minBlockSize;
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public long getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public byte[] put(InputStream in) throws IOException {
        ByteArrayOutputStream id = new ByteArrayOutputStream();
        int level = 0;
        try {
            while (!this.put(id, in, level)) {
                if (id.size() <= this.maxBlockSize / 2) continue;
                id = this.putIndirectId(id);
                ++level;
            }
        }
        catch (IOException e) {
            this.remove(id.toByteArray());
            throw e;
        }
        if (id.size() > this.minBlockSize * 2) {
            id = this.putIndirectId(id);
        }
        return id.toByteArray();
    }

    private boolean put(ByteArrayOutputStream id, InputStream in, int level) throws IOException {
        boolean eof;
        int len;
        byte[] buff;
        if (level > 0) {
            boolean eof2;
            ByteArrayOutputStream id2 = new ByteArrayOutputStream();
            do {
                eof2 = this.put(id2, in, level - 1);
                if (id2.size() <= this.maxBlockSize / 2) continue;
                id2 = this.putIndirectId(id2);
                id2.writeTo(id);
                return eof2;
            } while (!eof2);
            id2.writeTo(id);
            return true;
        }
        byte[] readBuffer = this.nextBuffer.getAndSet(null);
        if (readBuffer == null) {
            readBuffer = new byte[this.maxBlockSize];
        }
        if ((buff = StreamStore.read(in, readBuffer)) != readBuffer) {
            this.nextBuffer.set(readBuffer);
        }
        if ((len = buff.length) == 0) {
            return true;
        }
        boolean bl = eof = len < this.maxBlockSize;
        if (len < this.minBlockSize) {
            id.write(0);
            DataUtils.writeVarInt(id, len);
            id.write(buff);
        } else {
            id.write(1);
            DataUtils.writeVarInt(id, len);
            DataUtils.writeVarLong(id, this.writeBlock(buff));
        }
        return eof;
    }

    private static byte[] read(InputStream in, byte[] target) throws IOException {
        int len;
        int copied = 0;
        for (int remaining = target.length; remaining > 0; remaining -= len) {
            try {
                len = in.read(target, copied, remaining);
                if (len < 0) {
                    return Arrays.copyOf(target, copied);
                }
                copied += len;
                continue;
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }
        return target;
    }

    private ByteArrayOutputStream putIndirectId(ByteArrayOutputStream id) throws IOException {
        byte[] data = id.toByteArray();
        id = new ByteArrayOutputStream();
        id.write(2);
        DataUtils.writeVarLong(id, this.length(data));
        DataUtils.writeVarLong(id, this.writeBlock(data));
        return id;
    }

    private long writeBlock(byte[] data) {
        long key = this.getAndIncrementNextKey();
        this.map.put(key, data);
        this.onStore(data.length);
        return key;
    }

    protected void onStore(int len) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAndIncrementNextKey() {
        long key = this.nextKey.getAndIncrement();
        if (!this.map.containsKey(key)) {
            return key;
        }
        StreamStore streamStore = this;
        synchronized (streamStore) {
            long low = key;
            long high = Long.MAX_VALUE;
            while (low < high) {
                long x = low + high >>> 1;
                if (this.map.containsKey(x)) {
                    low = x + 1L;
                    continue;
                }
                high = x;
            }
            key = low;
            this.nextKey.set(key + 1L);
            return key;
        }
    }

    public long getMaxBlockKey(byte[] id) {
        long maxKey = -1L;
        ByteBuffer idBuffer = ByteBuffer.wrap(id);
        block5: while (idBuffer.hasRemaining()) {
            switch (idBuffer.get()) {
                case 0: {
                    int len = DataUtils.readVarInt(idBuffer);
                    idBuffer.position(idBuffer.position() + len);
                    continue block5;
                }
                case 1: {
                    DataUtils.readVarInt(idBuffer);
                    long k = DataUtils.readVarLong(idBuffer);
                    maxKey = Math.max(maxKey, k);
                    continue block5;
                }
                case 2: {
                    long k2;
                    DataUtils.readVarLong(idBuffer);
                    maxKey = k2 = DataUtils.readVarLong(idBuffer);
                    byte[] r = this.map.get(k2);
                    long m = this.getMaxBlockKey(r);
                    if (m < 0L) continue block5;
                    maxKey = Math.max(maxKey, m);
                    continue block5;
                }
            }
            throw DataUtils.newIllegalArgumentException("Unsupported id {0}", Arrays.toString(id));
        }
        return maxKey;
    }

    public void remove(byte[] id) {
        ByteBuffer idBuffer = ByteBuffer.wrap(id);
        block5: while (idBuffer.hasRemaining()) {
            switch (idBuffer.get()) {
                case 0: {
                    int len = DataUtils.readVarInt(idBuffer);
                    idBuffer.position(idBuffer.position() + len);
                    continue block5;
                }
                case 1: {
                    DataUtils.readVarInt(idBuffer);
                    long k = DataUtils.readVarLong(idBuffer);
                    this.map.remove(k);
                    continue block5;
                }
                case 2: {
                    DataUtils.readVarLong(idBuffer);
                    long k2 = DataUtils.readVarLong(idBuffer);
                    this.remove(this.map.get(k2));
                    this.map.remove(k2);
                    continue block5;
                }
            }
            throw DataUtils.newIllegalArgumentException("Unsupported id {0}", Arrays.toString(id));
        }
    }

    public static String toString(byte[] id) {
        StringBuilder buff = new StringBuilder();
        ByteBuffer idBuffer = ByteBuffer.wrap(id);
        long length = 0L;
        while (idBuffer.hasRemaining()) {
            switch (idBuffer.get()) {
                case 0: {
                    int len = DataUtils.readVarInt(idBuffer);
                    idBuffer.position(idBuffer.position() + len);
                    buff.append("data len=").append(len);
                    length += (long)len;
                    break;
                }
                case 1: {
                    int len = DataUtils.readVarInt(idBuffer);
                    length += (long)len;
                    long block = DataUtils.readVarLong(idBuffer);
                    buff.append("block ").append(block).append(" len=").append(len);
                    break;
                }
                case 2: {
                    int len = DataUtils.readVarInt(idBuffer);
                    length += DataUtils.readVarLong(idBuffer);
                    long block = DataUtils.readVarLong(idBuffer);
                    buff.append("indirect block ").append(block).append(" len=").append(len);
                    break;
                }
                default: {
                    buff.append("error");
                }
            }
            buff.append(", ");
        }
        buff.append("length=").append(length);
        return buff.toString();
    }

    public long length(byte[] id) {
        ByteBuffer idBuffer = ByteBuffer.wrap(id);
        long length = 0L;
        block5: while (idBuffer.hasRemaining()) {
            switch (idBuffer.get()) {
                case 0: {
                    int len = DataUtils.readVarInt(idBuffer);
                    idBuffer.position(idBuffer.position() + len);
                    length += (long)len;
                    continue block5;
                }
                case 1: {
                    length += (long)DataUtils.readVarInt(idBuffer);
                    DataUtils.readVarLong(idBuffer);
                    continue block5;
                }
                case 2: {
                    length += DataUtils.readVarLong(idBuffer);
                    DataUtils.readVarLong(idBuffer);
                    continue block5;
                }
            }
            throw DataUtils.newIllegalArgumentException("Unsupported id {0}", Arrays.toString(id));
        }
        return length;
    }

    public boolean isInPlace(byte[] id) {
        ByteBuffer idBuffer = ByteBuffer.wrap(id);
        while (idBuffer.hasRemaining()) {
            if (idBuffer.get() != 0) {
                return false;
            }
            int len = DataUtils.readVarInt(idBuffer);
            idBuffer.position(idBuffer.position() + len);
        }
        return true;
    }

    public InputStream get(byte[] id) {
        return new Stream(this, id);
    }

    byte[] getBlock(long key) {
        byte[] data = this.map.get(key);
        if (data == null) {
            throw DataUtils.newIllegalStateException(50, "Block {0} not found", key);
        }
        return data;
    }

    static class Stream
    extends InputStream {
        private final StreamStore store;
        private byte[] oneByteBuffer;
        private ByteBuffer idBuffer;
        private ByteArrayInputStream buffer;
        private long skip;
        private final long length;
        private long pos;

        Stream(StreamStore store, byte[] id) {
            this.store = store;
            this.length = store.length(id);
            this.idBuffer = ByteBuffer.wrap(id);
        }

        @Override
        public int read() throws IOException {
            int len;
            byte[] buffer = this.oneByteBuffer;
            if (buffer == null) {
                buffer = this.oneByteBuffer = new byte[1];
            }
            return (len = this.read(buffer, 0, 1)) == -1 ? -1 : buffer[0] & 0xFF;
        }

        @Override
        public long skip(long n) {
            if ((n = Math.min(this.length - this.pos, n)) == 0L) {
                return 0L;
            }
            if (this.buffer != null) {
                long s = this.buffer.skip(n);
                if (s > 0L) {
                    n = s;
                } else {
                    this.buffer = null;
                    this.skip += n;
                }
            } else {
                this.skip += n;
            }
            this.pos += n;
            return n;
        }

        @Override
        public void close() {
            this.buffer = null;
            this.idBuffer.position(this.idBuffer.limit());
            this.pos = this.length;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                return 0;
            }
            while (true) {
                int result;
                if (this.buffer == null) {
                    try {
                        this.buffer = this.nextBuffer();
                    }
                    catch (IllegalStateException e) {
                        String msg = DataUtils.formatMessage(50, "Block not found in id {0}", Arrays.toString(this.idBuffer.array()));
                        throw new IOException(msg, e);
                    }
                    if (this.buffer == null) {
                        return -1;
                    }
                }
                if ((result = this.buffer.read(b, off, len)) > 0) {
                    this.pos += (long)result;
                    return result;
                }
                this.buffer = null;
            }
        }

        private ByteArrayInputStream nextBuffer() {
            block5: while (this.idBuffer.hasRemaining()) {
                switch (this.idBuffer.get()) {
                    case 0: {
                        int len = DataUtils.readVarInt(this.idBuffer);
                        if (this.skip >= (long)len) {
                            this.skip -= (long)len;
                            this.idBuffer.position(this.idBuffer.position() + len);
                            continue block5;
                        }
                        int p = (int)((long)this.idBuffer.position() + this.skip);
                        int l = (int)((long)len - this.skip);
                        this.idBuffer.position(p + l);
                        return new ByteArrayInputStream(this.idBuffer.array(), p, l);
                    }
                    case 1: {
                        int len = DataUtils.readVarInt(this.idBuffer);
                        long key = DataUtils.readVarLong(this.idBuffer);
                        if (this.skip >= (long)len) {
                            this.skip -= (long)len;
                            continue block5;
                        }
                        byte[] data = this.store.getBlock(key);
                        int s = (int)this.skip;
                        this.skip = 0L;
                        return new ByteArrayInputStream(data, s, data.length - s);
                    }
                    case 2: {
                        long len = DataUtils.readVarLong(this.idBuffer);
                        long key = DataUtils.readVarLong(this.idBuffer);
                        if (this.skip >= len) {
                            this.skip -= len;
                            continue block5;
                        }
                        byte[] k = this.store.getBlock(key);
                        ByteBuffer newBuffer = ByteBuffer.allocate(k.length + this.idBuffer.limit() - this.idBuffer.position());
                        newBuffer.put(k);
                        newBuffer.put(this.idBuffer);
                        newBuffer.flip();
                        this.idBuffer = newBuffer;
                        return this.nextBuffer();
                    }
                }
                throw DataUtils.newIllegalArgumentException("Unsupported id {0}", Arrays.toString(this.idBuffer.array()));
            }
            return null;
        }
    }
}

