/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gridgain.internal.h2.util.StringUtils;

public final class DataUtils {
    public static final int ERROR_READING_FAILED = 1;
    public static final int ERROR_WRITING_FAILED = 2;
    public static final int ERROR_INTERNAL = 3;
    public static final int ERROR_CLOSED = 4;
    public static final int ERROR_UNSUPPORTED_FORMAT = 5;
    public static final int ERROR_FILE_CORRUPT = 6;
    public static final int ERROR_FILE_LOCKED = 7;
    public static final int ERROR_SERIALIZATION = 8;
    public static final int ERROR_CHUNK_NOT_FOUND = 9;
    public static final int ERROR_BLOCK_NOT_FOUND = 50;
    public static final int ERROR_TRANSACTION_CORRUPT = 100;
    public static final int ERROR_TRANSACTION_LOCKED = 101;
    public static final int ERROR_TOO_MANY_OPEN_TRANSACTIONS = 102;
    public static final int ERROR_TRANSACTION_ILLEGAL_STATE = 103;
    public static final int ERROR_TRANSACTION_TOO_BIG = 104;
    public static final int ERROR_TRANSACTIONS_DEADLOCK = 105;
    public static final int PAGE_TYPE_LEAF = 0;
    public static final int PAGE_TYPE_NODE = 1;
    public static final int PAGE_COMPRESSED = 2;
    public static final int PAGE_COMPRESSED_HIGH = 6;
    public static final int MAX_VAR_INT_LEN = 5;
    public static final int MAX_VAR_LONG_LEN = 10;
    public static final int COMPRESSED_VAR_INT_MAX = 0x1FFFFF;
    public static final long COMPRESSED_VAR_LONG_MAX = 0x1FFFFFFFFFFFFL;
    public static final int PAGE_LARGE = 0x200000;

    public static int getVarIntLen(int x) {
        if ((x & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((x & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((x & 0xFFE00000) == 0) {
            return 3;
        }
        if ((x & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int getVarLongLen(long x) {
        int i = 1;
        while ((x >>>= 7) != 0L) {
            ++i;
        }
        return i;
    }

    public static int readVarInt(ByteBuffer buff) {
        byte b = buff.get();
        if (b >= 0) {
            return b;
        }
        return DataUtils.readVarIntRest(buff, b);
    }

    private static int readVarIntRest(ByteBuffer buff, int b) {
        int x = b & 0x7F;
        b = buff.get();
        if (b >= 0) {
            return x | b << 7;
        }
        x |= (b & 0x7F) << 7;
        b = buff.get();
        if (b >= 0) {
            return x | b << 14;
        }
        x |= (b & 0x7F) << 14;
        b = buff.get();
        if (b >= 0) {
            return x | b << 21;
        }
        return x |= (b & 0x7F) << 21 | buff.get() << 28;
    }

    public static long readVarLong(ByteBuffer buff) {
        long x = buff.get();
        if (x >= 0L) {
            return x;
        }
        x &= 0x7FL;
        for (int s = 7; s < 64; s += 7) {
            long b = buff.get();
            x |= (b & 0x7FL) << s;
            if (b >= 0L) break;
        }
        return x;
    }

    public static void writeVarInt(OutputStream out, int x) throws IOException {
        while ((x & 0xFFFFFF80) != 0) {
            out.write((byte)(x | 0x80));
            x >>>= 7;
        }
        out.write((byte)x);
    }

    public static void writeVarInt(ByteBuffer buff, int x) {
        while ((x & 0xFFFFFF80) != 0) {
            buff.put((byte)(x | 0x80));
            x >>>= 7;
        }
        buff.put((byte)x);
    }

    public static void writeStringData(ByteBuffer buff, String s, int len) {
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                buff.put((byte)c);
                continue;
            }
            if (c >= '\u0800') {
                buff.put((byte)(0xE0 | c >> 12));
                buff.put((byte)(c >> 6 & 0x3F));
                buff.put((byte)(c & 0x3F));
                continue;
            }
            buff.put((byte)(0xC0 | c >> 6));
            buff.put((byte)(c & 0x3F));
        }
    }

    public static String readString(ByteBuffer buff, int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            int x = buff.get() & 0xFF;
            chars[i] = x < 128 ? (char)x : (x >= 224 ? (char)(((x & 0xF) << 12) + ((buff.get() & 0x3F) << 6) + (buff.get() & 0x3F)) : (char)(((x & 0x1F) << 6) + (buff.get() & 0x3F)));
        }
        return new String(chars);
    }

    public static void writeVarLong(ByteBuffer buff, long x) {
        while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buff.put((byte)(x | 0x80L));
            x >>>= 7;
        }
        buff.put((byte)x);
    }

    public static void writeVarLong(OutputStream out, long x) throws IOException {
        while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((byte)(x | 0x80L));
            x >>>= 7;
        }
        out.write((byte)x);
    }

    public static void copyWithGap(Object src, Object dst, int oldSize, int gapIndex) {
        if (gapIndex > 0) {
            System.arraycopy(src, 0, dst, 0, gapIndex);
        }
        if (gapIndex < oldSize) {
            System.arraycopy(src, gapIndex, dst, gapIndex + 1, oldSize - gapIndex);
        }
    }

    public static void copyExcept(Object src, Object dst, int oldSize, int removeIndex) {
        if (removeIndex > 0 && oldSize > 0) {
            System.arraycopy(src, 0, dst, 0, removeIndex);
        }
        if (removeIndex < oldSize) {
            System.arraycopy(src, removeIndex + 1, dst, removeIndex, oldSize - removeIndex - 1);
        }
    }

    public static void readFully(FileChannel file, long pos, ByteBuffer dst) {
        try {
            do {
                int len;
                if ((len = file.read(dst, pos)) < 0) {
                    throw new EOFException();
                }
                pos += (long)len;
            } while (dst.remaining() > 0);
            dst.rewind();
        }
        catch (IOException e) {
            long size;
            try {
                size = file.size();
            }
            catch (IOException e2) {
                size = -1L;
            }
            throw DataUtils.newIllegalStateException(1, "Reading from {0} failed; file length {1} read length {2} at {3}", file, size, dst.remaining(), pos, e);
        }
    }

    public static void writeFully(FileChannel file, long pos, ByteBuffer src) {
        try {
            int off = 0;
            do {
                int len = file.write(src, pos + (long)off);
                off += len;
            } while (src.remaining() > 0);
        }
        catch (IOException e) {
            throw DataUtils.newIllegalStateException(2, "Writing to {0} failed; length {1} at {2}", file, src.remaining(), pos, e);
        }
    }

    public static int encodeLength(int len) {
        if (len <= 32) {
            return 0;
        }
        int code = Integer.numberOfLeadingZeros(len);
        int remaining = len << code + 1;
        code += code;
        if ((remaining & Integer.MIN_VALUE) != 0) {
            --code;
        }
        if (remaining << 1 != 0) {
            --code;
        }
        code = Math.min(31, 52 - code);
        return code;
    }

    public static int getPageChunkId(long pos) {
        return (int)(pos >>> 38);
    }

    public static int getPageMaxLength(long pos) {
        int code = (int)(pos >> 1 & 0x1FL);
        if (code == 31) {
            return 0x200000;
        }
        return 2 + (code & 1) << (code >> 1) + 4;
    }

    public static int getPageOffset(long pos) {
        return (int)(pos >> 6);
    }

    public static int getPageType(long pos) {
        return (int)pos & 1;
    }

    public static boolean isPageSaved(long pos) {
        return pos != 0L;
    }

    public static long getPagePos(int chunkId, int offset, int length, int type) {
        long pos = (long)chunkId << 38;
        pos |= (long)offset << 6;
        pos |= (long)(DataUtils.encodeLength(length) << 1);
        return pos |= (long)type;
    }

    public static short getCheckValue(int x) {
        return (short)(x >> 16 ^ x);
    }

    public static StringBuilder appendMap(StringBuilder buff, HashMap<String, ?> map) {
        Object[] keys = map.keySet().toArray();
        Arrays.sort(keys);
        for (Object k : keys) {
            String key = (String)k;
            Object value = map.get(key);
            if (value instanceof Long) {
                DataUtils.appendMap(buff, key, (Long)value);
                continue;
            }
            if (value instanceof Integer) {
                DataUtils.appendMap(buff, key, (Integer)value);
                continue;
            }
            DataUtils.appendMap(buff, key, value.toString());
        }
        return buff;
    }

    private static StringBuilder appendMapKey(StringBuilder buff, String key) {
        if (buff.length() > 0) {
            buff.append(',');
        }
        return buff.append(key).append(':');
    }

    public static void appendMap(StringBuilder buff, String key, String value) {
        DataUtils.appendMapKey(buff, key);
        if (value.indexOf(44) < 0 && value.indexOf(34) < 0) {
            buff.append(value);
        } else {
            buff.append('\"');
            int size = value.length();
            for (int i = 0; i < size; ++i) {
                char c = value.charAt(i);
                if (c == '\"') {
                    buff.append('\\');
                }
                buff.append(c);
            }
            buff.append('\"');
        }
    }

    public static void appendMap(StringBuilder buff, String key, long value) {
        DataUtils.appendMapKey(buff, key).append(Long.toHexString(value));
    }

    public static void appendMap(StringBuilder buff, String key, int value) {
        DataUtils.appendMapKey(buff, key).append(Integer.toHexString(value));
    }

    private static int parseMapValue(StringBuilder buff, String s, int i, int size) {
        char c;
        block0: while (i < size && (c = s.charAt(i++)) != ',') {
            if (c == '\"') {
                while (i < size) {
                    if ((c = s.charAt(i++)) == '\\') {
                        if (i == size) {
                            throw DataUtils.newIllegalStateException(6, "Not a map: {0}", s);
                        }
                        c = s.charAt(i++);
                    } else if (c == '\"') continue block0;
                    buff.append(c);
                }
                continue;
            }
            buff.append(c);
        }
        return i;
    }

    public static HashMap<String, String> parseMap(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder buff = new StringBuilder();
        int i = 0;
        int size = s.length();
        while (i < size) {
            int startKey = i;
            if ((i = s.indexOf(58, i)) < 0) {
                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", s);
            }
            String key = s.substring(startKey, i++);
            i = DataUtils.parseMapValue(buff, s, i, size);
            map.put(key, buff.toString());
            buff.setLength(0);
        }
        return map;
    }

    public static HashMap<String, String> parseChecksummedMap(byte[] bytes) {
        int start;
        int end = bytes.length;
        for (start = 0; start < end && bytes[start] <= 32; ++start) {
        }
        while (start < end && bytes[end - 1] <= 32) {
            --end;
        }
        String s = new String(bytes, start, end - start, StandardCharsets.ISO_8859_1);
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder buff = new StringBuilder();
        int i = 0;
        int size = s.length();
        while (i < size) {
            int startKey = i;
            if ((i = s.indexOf(58, i)) < 0) {
                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", s);
            }
            if (i - startKey == 8 && s.regionMatches(startKey, "fletcher", 0, 8)) {
                DataUtils.parseMapValue(buff, s, i + 1, size);
                int check = (int)Long.parseLong(buff.toString(), 16);
                if (check == DataUtils.getFletcher32(bytes, start, startKey - 1)) {
                    return map;
                }
                return null;
            }
            String key = s.substring(startKey, i++);
            i = DataUtils.parseMapValue(buff, s, i, size);
            map.put(key, buff.toString());
            buff.setLength(0);
        }
        return null;
    }

    public static String getMapName(String s) {
        return DataUtils.getFromMap(s, "name");
    }

    public static String getFromMap(String s, String key) {
        int keyLength = key.length();
        int i = 0;
        int size = s.length();
        while (i < size) {
            char c;
            int startKey = i;
            if ((i = s.indexOf(58, i)) < 0) {
                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", s);
            }
            if (i++ - startKey == keyLength && s.regionMatches(startKey, key, 0, keyLength)) {
                StringBuilder buff = new StringBuilder();
                DataUtils.parseMapValue(buff, s, i, size);
                return buff.toString();
            }
            block1: while (i < size && (c = s.charAt(i++)) != ',') {
                if (c != '\"') continue;
                while (i < size) {
                    if ((c = s.charAt(i++)) == '\\') {
                        if (i++ != size) continue;
                        throw DataUtils.newIllegalStateException(6, "Not a map: {0}", s);
                    }
                    if (c != '\"') continue;
                    continue block1;
                }
            }
        }
        return null;
    }

    public static int getFletcher32(byte[] bytes, int offset, int length) {
        int s1 = 65535;
        int s2 = 65535;
        int i = offset;
        int len = offset + (length & 0xFFFFFFFE);
        while (i < len) {
            int end = Math.min(i + 720, len);
            while (i < end) {
                int x = (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
                s2 += (s1 += x);
            }
            s1 = (s1 & 0xFFFF) + (s1 >>> 16);
            s2 = (s2 & 0xFFFF) + (s2 >>> 16);
        }
        if ((length & 1) != 0) {
            int x = (bytes[i] & 0xFF) << 8;
            s2 += (s1 += x);
        }
        s1 = (s1 & 0xFFFF) + (s1 >>> 16);
        s2 = (s2 & 0xFFFF) + (s2 >>> 16);
        return s2 << 16 | s1;
    }

    public static void checkArgument(boolean test, String message, Object ... arguments) {
        if (!test) {
            throw DataUtils.newIllegalArgumentException(message, arguments);
        }
    }

    public static IllegalArgumentException newIllegalArgumentException(String message, Object ... arguments) {
        return DataUtils.initCause(new IllegalArgumentException(DataUtils.formatMessage(0, message, arguments)), arguments);
    }

    public static UnsupportedOperationException newUnsupportedOperationException(String message) {
        return new UnsupportedOperationException(DataUtils.formatMessage(0, message, new Object[0]));
    }

    public static IllegalStateException newIllegalStateException(int errorCode, String message, Object ... arguments) {
        return DataUtils.initCause(new IllegalStateException(DataUtils.formatMessage(errorCode, message, arguments)), arguments);
    }

    private static <T extends Exception> T initCause(T e, Object ... arguments) {
        Object o;
        int size = arguments.length;
        if (size > 0 && (o = arguments[size - 1]) instanceof Throwable) {
            e.initCause((Throwable)o);
        }
        return e;
    }

    public static String formatMessage(int errorCode, String message, Object ... arguments) {
        arguments = (Object[])arguments.clone();
        for (int i = 0; i < arguments.length; ++i) {
            String s;
            Object a = arguments[i];
            if (a instanceof Exception) continue;
            String string = s = a == null ? "null" : a.toString();
            if (s.length() > 1000) {
                s = s.substring(0, 1000) + "...";
            }
            arguments[i] = s;
        }
        return MessageFormat.format(message, arguments) + " [" + 1 + "." + 4 + "." + 199 + "/" + errorCode + "]";
    }

    public static int getErrorCode(String m) {
        int dash;
        if (m != null && m.endsWith("]") && (dash = m.lastIndexOf(47)) >= 0) {
            try {
                return StringUtils.parseUInt31(m, dash + 1, m.length() - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static long readHexLong(Map<String, ?> map, String key, long defaultValue) {
        Object v = map.get(key);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        try {
            return DataUtils.parseHexLong((String)v);
        }
        catch (NumberFormatException e) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", v, e);
        }
    }

    public static long parseHexLong(String x) {
        try {
            if (x.length() == 16) {
                return Long.parseLong(x.substring(0, 8), 16) << 32 | Long.parseLong(x.substring(8, 16), 16);
            }
            return Long.parseLong(x, 16);
        }
        catch (NumberFormatException e) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", x, e);
        }
    }

    public static int parseHexInt(String x) {
        try {
            return (int)Long.parseLong(x, 16);
        }
        catch (NumberFormatException e) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", x, e);
        }
    }

    public static int readHexInt(Map<String, ?> map, String key, int defaultValue) {
        Object v = map.get(key);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        try {
            return (int)Long.parseLong((String)v, 16);
        }
        catch (NumberFormatException e) {
            throw DataUtils.newIllegalStateException(6, "Error parsing the value {0}", v, e);
        }
    }

    public static int getConfigParam(Map<String, ?> config, String key, int defaultValue) {
        Object o = config.get(key);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o != null) {
            try {
                return Integer.decode(o.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

