/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridgain.internal.h2.mvstore.CursorPos;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.Page;

public class Cursor<K, V>
implements Iterator<K> {
    private final K to;
    private CursorPos cursorPos;
    private CursorPos keeper;
    private K current;
    private K last;
    private V lastValue;
    private Page lastPage;

    public Cursor(Page root, K from) {
        this(root, from, null);
    }

    public Cursor(Page root, K from, K to) {
        this.cursorPos = Cursor.traverseDown(root, from);
        this.to = to;
    }

    @Override
    public boolean hasNext() {
        if (this.cursorPos != null) {
            while (this.current == null) {
                CursorPos tmp;
                int index = this.cursorPos.index;
                Page page = this.cursorPos.page;
                if (index >= (page.isLeaf() ? page.getKeyCount() : page.map.getChildPageCount(page))) {
                    tmp = this.cursorPos;
                    this.cursorPos = this.cursorPos.parent;
                    tmp.parent = this.keeper;
                    this.keeper = tmp;
                    if (this.cursorPos == null) {
                        return false;
                    }
                } else {
                    while (!page.isLeaf()) {
                        page = page.getChildPage(index);
                        if (this.keeper == null) {
                            this.cursorPos = new CursorPos(page, 0, this.cursorPos);
                        } else {
                            tmp = this.keeper;
                            this.keeper = this.keeper.parent;
                            tmp.parent = this.cursorPos;
                            tmp.page = page;
                            tmp.index = 0;
                            this.cursorPos = tmp;
                        }
                        index = 0;
                    }
                    Object key = page.getKey(index);
                    if (this.to != null && page.map.getKeyType().compare(key, this.to) > 0) {
                        return false;
                    }
                    this.last = key;
                    this.current = this.last;
                    this.lastValue = page.getValue(index);
                    this.lastPage = page;
                }
                ++this.cursorPos.index;
            }
        }
        return this.current != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = null;
        return this.last;
    }

    public K getKey() {
        return this.last;
    }

    public V getValue() {
        return this.lastValue;
    }

    Page getPage() {
        return this.lastPage;
    }

    public void skip(long n) {
        if (n < 10L) {
            while (n-- > 0L && this.hasNext()) {
                this.next();
            }
        } else if (this.hasNext()) {
            CursorPos parent;
            assert (this.cursorPos != null);
            CursorPos cp = this.cursorPos;
            while ((parent = cp.parent) != null) {
                cp = parent;
            }
            Page root = cp.page;
            MVMap<?, ?> map = root.map;
            long index = map.getKeyIndex(this.next());
            this.last = map.getKey(index + n);
            this.cursorPos = Cursor.traverseDown(root, this.last);
        }
    }

    @Override
    public void remove() {
        throw DataUtils.newUnsupportedOperationException("Removal is not supported");
    }

    private static CursorPos traverseDown(Page p, Object key) {
        int index;
        CursorPos cursorPos = null;
        while (!p.isLeaf()) {
            index = 0;
            if (key != null && (index = p.binarySearch(key) + 1) < 0) {
                index = -index;
            }
            cursorPos = new CursorPos(p, index, cursorPos);
            p = p.getChildPage(index);
        }
        index = 0;
        if (key != null && (index = p.binarySearch(key)) < 0) {
            index = -index - 1;
        }
        return new CursorPos(p, index, cursorPos);
    }
}

