/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.ViewIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class ViewCursor
implements Cursor {
    private final Table table;
    private final ViewIndex index;
    private final ResultInterface result;
    private final SearchRow first;
    private final SearchRow last;
    private Row current;

    public ViewCursor(ViewIndex index, ResultInterface result, SearchRow first, SearchRow last) {
        this.table = index.getTable();
        this.index = index;
        this.result = result;
        this.first = first;
        this.last = last;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int comp;
        do {
            boolean res;
            if (!(res = this.result.next())) {
                if (this.index.isRecursive()) {
                    this.result.reset();
                } else {
                    this.result.close();
                }
                this.current = null;
                return false;
            }
            this.current = this.table.getTemplateRow();
            Value[] values = this.result.currentRow();
            int len = this.current.getColumnCount();
            for (int i = 0; i < len; ++i) {
                ValueNull v = i < values.length ? values[i] : ValueNull.INSTANCE;
                this.current.setValue(i, v);
            }
        } while (this.first != null && (comp = this.index.compareRows(this.current, this.first)) < 0 || this.last != null && (comp = this.index.compareRows(this.current, this.last)) > 0);
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

