/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import java.util.ArrayList;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.expression.condition.ConditionInConstantSet;
import org.gridgain.internal.h2.expression.condition.ConditionInParameter;
import org.gridgain.internal.h2.expression.function.TableFunction;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private final Database database;
    private Expression left;
    private final ArrayList<Expression> valueList;

    public ConditionIn(Database database, Expression left, ArrayList<Expression> values) {
        this.database = database;
        this.left = left;
        this.valueList = values;
    }

    @Override
    public Value getValue(Session session) {
        Expression e;
        Value l = this.left.getValue(session);
        if (l.containsNull()) {
            return ValueNull.INSTANCE;
        }
        int size = this.valueList.size();
        if (size == 1 && (e = this.valueList.get(0)) instanceof TableFunction) {
            return ConditionInParameter.getValue(this.database, l, e.getValue(session));
        }
        boolean hasNull = false;
        for (int i = 0; i < size; ++i) {
            Expression e2 = this.valueList.get(i);
            Value r = e2.getValue(session);
            Value cmp = Comparison.compare(this.database, l, r, 0);
            if (cmp == ValueNull.INSTANCE) {
                hasNull = true;
                continue;
            }
            if (cmp != ValueBoolean.TRUE) continue;
            return cmp;
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.FALSE;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        for (Expression e : this.valueList) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(Session session) {
        Expression right;
        this.left = this.left.optimize(session);
        boolean constant = this.left.isConstant();
        if (constant && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        int size = this.valueList.size();
        if (size == 1 && (right = this.valueList.get(0)) instanceof TableFunction) {
            Expression arg;
            Expression[] args;
            TableFunction tf = (TableFunction)right;
            if (tf.getFunctionType() == 233 && (args = tf.getArgs()).length == 1 && (arg = args[0]) instanceof Parameter) {
                return new ConditionInParameter(this.database, this.left, (Parameter)arg);
            }
            if (tf.isConstant()) {
                boolean allValuesNull = true;
                ResultInterface ri = right.getValue(session).getResult();
                ArrayList<Expression> list = new ArrayList<Expression>(ri.getRowCount());
                while (ri.next()) {
                    Value v = ri.currentRow()[0];
                    if (!v.containsNull()) {
                        allValuesNull = false;
                    }
                    list.add(ValueExpression.get(v));
                }
                return this.optimize2(session, constant, true, allValuesNull, list);
            }
            return this;
        }
        boolean allValuesConstant = true;
        boolean allValuesNull = true;
        for (int i = 0; i < size; ++i) {
            Expression e = this.valueList.get(i);
            if ((e = e.optimize(session)).isConstant() && !e.getValue(session).containsNull()) {
                allValuesNull = false;
            }
            if (allValuesConstant && !e.isConstant()) {
                allValuesConstant = false;
            }
            if (this.left instanceof ExpressionColumn && e instanceof Parameter) {
                ((Parameter)e).setColumn(((ExpressionColumn)this.left).getColumn());
            }
            this.valueList.set(i, e);
        }
        return this.optimize2(session, constant, allValuesConstant, allValuesNull, this.valueList);
    }

    private Expression optimize2(Session session, boolean constant, boolean allValuesConstant, boolean allValuesNull, ArrayList<Expression> values) {
        if (constant && allValuesConstant) {
            return ValueExpression.get(this.getValue(session));
        }
        if (values.size() == 1) {
            return new Comparison(session, 0, this.left, values.get(0)).optimize(session);
        }
        if (allValuesConstant && !allValuesNull) {
            int leftType = this.left.getType().getValueType();
            if (leftType == -1) {
                return this;
            }
            if (leftType == 25 && !(this.left instanceof ExpressionColumn)) {
                return this;
            }
            Expression expr = new ConditionInConstantSet(session, this.left, values);
            expr = ((Expression)expr).optimize(session);
            return expr;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            ExpressionVisitor visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
            for (Expression e : this.valueList) {
                if (e.isEverything(visitor)) continue;
                return;
            }
            filter.addIndexCondition(IndexCondition.getInList(l, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        for (Expression e : this.valueList) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(" IN(");
        ConditionIn.writeExpressions(builder, this.valueList, alwaysQuote);
        return builder.append("))");
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
        for (Expression e : this.valueList) {
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!this.left.isEverything(visitor)) {
            return false;
        }
        return this.areAllValues(visitor);
    }

    private boolean areAllValues(ExpressionVisitor visitor) {
        for (Expression e : this.valueList) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.left.getCost();
        for (Expression e : this.valueList) {
            cost += e.getCost();
        }
        return cost;
    }

    Expression getAdditional(Comparison other) {
        Expression add = other.getIfEquals(this.left);
        if (add != null) {
            this.valueList.add(add);
            return this;
        }
        return null;
    }

    @Override
    public int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        if (index > 0 && index <= this.valueList.size()) {
            return this.valueList.get(index - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

