/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.SimpleResult;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueResultSet
extends Value {
    private final SimpleResult result;

    private ValueResultSet(SimpleResult result) {
        this.result = result;
    }

    public static ValueResultSet get(SimpleResult result) {
        return new ValueResultSet(result);
    }

    public static ValueResultSet get(SessionInterface session, ResultSet rs, int maxrows) {
        try {
            int i;
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            SimpleResult simple = new SimpleResult();
            for (i = 0; i < columnCount; ++i) {
                String alias = meta.getColumnLabel(i + 1);
                String name = meta.getColumnName(i + 1);
                int columnType = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1), meta.getColumnTypeName(i + 1));
                int precision = meta.getPrecision(i + 1);
                int scale = meta.getScale(i + 1);
                simple.addColumn(alias, name, columnType, precision, scale);
            }
            for (i = 0; i < maxrows && rs.next(); ++i) {
                Value[] list = new Value[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    list[j] = DataType.convertToValue(session, rs.getObject(j + 1), simple.getColumnType(j).getValueType());
                }
                simple.addRow(list);
            }
            return new ValueResultSet(simple);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    public static ValueResultSet get(ResultInterface result, int maxrows) {
        int i;
        int columnCount = result.getVisibleColumnCount();
        SimpleResult simple = new SimpleResult();
        for (i = 0; i < columnCount; ++i) {
            simple.addColumn(result.getAlias(i), result.getColumnName(i), result.getColumnType(i));
        }
        result.reset();
        for (i = 0; i < maxrows && result.next(); ++i) {
            simple.addRow(Arrays.copyOf(result.currentRow(), columnCount));
        }
        return new ValueResultSet(simple);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_RESULT_SET;
    }

    @Override
    public int getValueType() {
        return 18;
    }

    @Override
    public int getMemory() {
        return this.result.getRowCount() * this.result.getVisibleColumnCount() * 32 + 400;
    }

    @Override
    public String getString() {
        StringBuilder buff = new StringBuilder("(");
        ResultInterface result = this.result.createShallowCopy(null);
        int columnCount = result.getVisibleColumnCount();
        int i = 0;
        while (result.next()) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append('(');
            Value[] row = result.currentRow();
            for (int j = 0; j < columnCount; ++j) {
                if (j > 0) {
                    buff.append(", ");
                }
                buff.append(row[j].getString());
            }
            buff.append(')');
            ++i;
        }
        return buff.append(')').toString();
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        return this == v ? 0 : this.getString().compareTo(v.getString());
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Object getObject() {
        return this.getString();
    }

    @Override
    public ResultInterface getResult() {
        return this.result.createShallowCopy(null);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) {
        throw this.getUnsupportedExceptionForOperation("PreparedStatement.set");
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return builder;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (!force) {
            return this;
        }
        return ValueResultSet.get(new SimpleResult());
    }
}

