/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueBytes
extends Value {
    public static final ValueBytes EMPTY = new ValueBytes(Utils.EMPTY_BYTES);
    protected byte[] value;
    protected TypeInfo type;
    protected int hash;

    protected ValueBytes(byte[] v) {
        this.value = v;
    }

    public static ValueBytes get(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        b = Utils.cloneByteArray(b);
        return ValueBytes.getNoCopy(b);
    }

    public static ValueBytes getNoCopy(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        ValueBytes obj = new ValueBytes(b);
        if (b.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueBytes)Value.cache(obj);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            long precision = this.value.length;
            this.type = type = new TypeInfo(12, precision, 0, MathUtils.convertLongToInt(precision * 2L), null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 12;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("X'");
        return StringUtils.convertBytesToHex(builder, this.getBytesNoCopy()).append('\'');
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        byte[] v2 = ((ValueBytes)v).value;
        if (mode.isBinaryUnsigned()) {
            return Bits.compareNotNullUnsigned(this.value, v2);
        }
        return Bits.compareNotNullSigned(this.value, v2);
    }

    @Override
    public String getString() {
        return StringUtils.convertBytesToHex(this.value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Utils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.value);
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueBytes && Arrays.equals(this.value, ((ValueBytes)other).value);
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if ((long)this.value.length <= precision) {
            return this;
        }
        int len = MathUtils.convertLongToInt(precision);
        return ValueBytes.getNoCopy(Arrays.copyOf(this.value, len));
    }
}

