/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.HashMap;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.IOUtils;

public class TempFileDeleter {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final HashMap<PhantomReference<?>, Object> refMap = new HashMap();

    private TempFileDeleter() {
    }

    public static TempFileDeleter getInstance() {
        return new TempFileDeleter();
    }

    public synchronized Reference<?> addFile(Object resource, Object monitor) {
        if (!(resource instanceof String) && !(resource instanceof AutoCloseable)) {
            throw DbException.getUnsupportedException("Unsupported resource " + resource);
        }
        IOUtils.trace("TempFileDeleter.addFile", resource instanceof String ? (String)resource : "-", monitor);
        PhantomReference<Object> ref = new PhantomReference<Object>(monitor, this.queue);
        this.refMap.put(ref, resource);
        this.deleteUnused();
        return ref;
    }

    public synchronized void deleteFile(Reference<?> ref, Object resource) {
        Object f2;
        if (ref != null && (f2 = this.refMap.remove(ref)) != null) {
            if (SysProperties.CHECK && resource != null && !f2.equals(resource)) {
                DbException.throwInternalError("f2:" + f2 + " f:" + resource);
            }
            resource = f2;
        }
        if (resource instanceof String) {
            String fileName = (String)resource;
            if (FileUtils.exists(fileName)) {
                try {
                    IOUtils.trace("TempFileDeleter.deleteFile", fileName, null);
                    FileUtils.tryDelete(fileName);
                }
                catch (Exception exception) {}
            }
        } else if (resource instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)resource;
            try {
                IOUtils.trace("TempFileDeleter.deleteCloseable", "-", null);
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteAll() {
        for (Object resource : new ArrayList<Object>(this.refMap.values())) {
            this.deleteFile(null, resource);
        }
        this.deleteUnused();
    }

    public void deleteUnused() {
        Reference<Object> ref;
        while (this.queue != null && (ref = this.queue.poll()) != null) {
            this.deleteFile(ref, null);
        }
    }

    public void stopAutoDelete(Reference<?> ref, Object resource) {
        IOUtils.trace("TempFileDeleter.stopAutoDelete", resource instanceof String ? (String)resource : "-", ref);
        if (ref != null) {
            Object f2 = this.refMap.remove(ref);
            if (SysProperties.CHECK && (f2 == null || !f2.equals(resource))) {
                DbException.throwInternalError("f2:" + f2 + " " + (f2 == null ? "" : f2) + " f:" + resource);
            }
        }
        this.deleteUnused();
    }
}

