/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.fs.FileChannelInputStream;
import org.gridgain.internal.h2.store.fs.FilePath;
import org.gridgain.internal.h2.store.fs.FilePathDisk;
import org.gridgain.internal.h2.store.fs.FileZip;

public class FilePathZip
extends FilePath {
    @Override
    public FilePathZip getPath(String path) {
        FilePathZip p = new FilePathZip();
        p.name = path;
        return p;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        try {
            String entryName = this.getEntryName();
            if (entryName.isEmpty()) {
                return true;
            }
            try (ZipFile file = this.openZipFile();){
                boolean bl = file.getEntry(entryName) != null;
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int idx = this.name.lastIndexOf(47);
        return idx < 0 ? null : this.getPath(this.name.substring(0, idx));
    }

    @Override
    public boolean isAbsolute() {
        String fileName = FilePathZip.translateFileName(this.name);
        return FilePath.get(fileName).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory() {
        try {
            String entryName = this.getEntryName();
            if (entryName.isEmpty()) {
                return true;
            }
            try (ZipFile file = this.openZipFile();){
                String n;
                Enumeration<? extends ZipEntry> en = file.entries();
                do {
                    if (!en.hasMoreElements()) return false;
                    ZipEntry entry = en.nextElement();
                    n = entry.getName();
                    if (!n.equals(entryName)) continue;
                    boolean bl = entry.isDirectory();
                    return bl;
                } while (!n.startsWith(entryName) || n.length() != entryName.length() + 1 || !n.equals(entryName + "/"));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long size() {
        try (ZipFile file = this.openZipFile();){
            ZipEntry entry = file.getEntry(this.getEntryName());
            long l = entry == null ? 0L : entry.getSize();
            return l;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ArrayList<FilePath> newDirectoryStream() {
        String path = this.name;
        ArrayList<FilePath> list = new ArrayList<FilePath>();
        try {
            if (path.indexOf(33) < 0) {
                path = path + "!";
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            try (ZipFile file = this.openZipFile();){
                String dirName = this.getEntryName();
                String prefix = path.substring(0, path.length() - dirName.length());
                Enumeration<? extends ZipEntry> en = file.entries();
                while (en.hasMoreElements()) {
                    int idx;
                    ZipEntry entry = en.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(dirName) || name.length() <= dirName.length() || (idx = name.indexOf(47, dirName.length())) >= 0 && idx < name.length() - 1) continue;
                    list.add(this.getPath(prefix + name));
                }
            }
            return list;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "listFiles " + path);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        ZipFile file = this.openZipFile();
        ZipEntry entry = file.getEntry(this.getEntryName());
        if (entry == null) {
            file.close();
            throw new FileNotFoundException(this.name);
        }
        return new FileZip(file, entry);
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        throw new IOException("write");
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        throw DbException.getUnsupportedException("write");
    }

    private static String translateFileName(String fileName) {
        int idx;
        if (fileName.startsWith("zip:")) {
            fileName = fileName.substring("zip:".length());
        }
        if ((idx = fileName.indexOf(33)) >= 0) {
            fileName = fileName.substring(0, idx);
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    private String getEntryName() {
        int idx = this.name.indexOf(33);
        String fileName = idx <= 0 ? "" : this.name.substring(idx + 1);
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private ZipFile openZipFile() throws IOException {
        String fileName = FilePathZip.translateFileName(this.name);
        return new ZipFile(fileName);
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        if (!inTempDir) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(suffix, true);
    }

    @Override
    public String getScheme() {
        return "zip";
    }
}

