/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.api.TableEngine;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.FileStore;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.MVStoreTool;
import org.gridgain.internal.h2.mvstore.db.MVTable;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.store.InDoubtTransaction;
import org.gridgain.internal.h2.store.fs.FileChannelInputStream;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.table.TableBase;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class MVTableEngine
implements TableEngine {
    public static Store init(final Database db) {
        Store store = db.getStore();
        if (store != null) {
            return store;
        }
        byte[] key = db.getFileEncryptionKey();
        String dbPath = db.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        store = new Store();
        boolean encrypted = false;
        if (dbPath != null) {
            String fileName = dbPath + ".mv.db";
            MVStoreTool.compactCleanUp(fileName);
            builder.fileName(fileName);
            builder.pageSplitSize(db.getPageSize());
            if (db.isReadOnly()) {
                builder.readOnly();
            } else {
                boolean exists = FileUtils.exists(fileName);
                if (!exists || FileUtils.canWrite(fileName)) {
                    String dir = FileUtils.getParent(fileName);
                    FileUtils.createDirectories(dir);
                }
            }
            if (key != null) {
                encrypted = true;
                builder.encryptionKey(MVTableEngine.decodePassword(key));
            }
            if (db.getSettings().compressData) {
                builder.compress();
                builder.pageSplitSize(65536);
            }
            builder.backgroundExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    db.setBackgroundException(DbException.convert(e));
                }
            });
        }
        store.open(db, builder, encrypted);
        db.setStore(store);
        return store;
    }

    static char[] decodePassword(byte[] key) {
        char[] password = new char[key.length / 2];
        for (int i = 0; i < password.length; ++i) {
            password[i] = (char)((key[i + i] & 0xFF) << 16 | key[i + i + 1] & 0xFF);
        }
        return password;
    }

    @Override
    public TableBase createTable(CreateTableData data) {
        Database db = data.session.getDatabase();
        Store store = MVTableEngine.init(db);
        return store.createTable(data);
    }

    private static class MVInDoubtTransaction
    implements InDoubtTransaction {
        private final MVStore store;
        private final Transaction transaction;
        private int state = 0;

        MVInDoubtTransaction(MVStore store, Transaction transaction) {
            this.store = store;
            this.transaction = transaction;
        }

        @Override
        public void setState(int state) {
            if (state == 1) {
                this.transaction.commit();
            } else {
                this.transaction.rollback();
            }
            this.store.commit();
            this.state = state;
        }

        @Override
        public String getState() {
            switch (this.state) {
                case 0: {
                    return "IN_DOUBT";
                }
                case 1: {
                    return "COMMIT";
                }
                case 2: {
                    return "ROLLBACK";
                }
            }
            throw DbException.throwInternalError("state=" + this.state);
        }

        @Override
        public String getTransactionName() {
            return this.transaction.getName();
        }
    }

    public static class Store {
        private final ConcurrentHashMap<String, MVTable> tableMap = new ConcurrentHashMap();
        private MVStore mvStore;
        private TransactionStore transactionStore;
        private long statisticsStart;
        private int temporaryMapId;
        private boolean encrypted;
        private String fileName;

        void open(Database db, MVStore.Builder builder, boolean encrypted) {
            this.encrypted = encrypted;
            try {
                this.mvStore = builder.open();
                FileStore fs = this.mvStore.getFileStore();
                if (fs != null) {
                    this.fileName = fs.getFileName();
                }
                if (!db.getSettings().reuseSpace) {
                    this.mvStore.setReuseSpace(false);
                }
                this.transactionStore = new TransactionStore(this.mvStore, new ValueDataType(db, null), db.getLockTimeout());
            }
            catch (IllegalStateException e) {
                throw this.convertIllegalStateException(e);
            }
        }

        DbException convertIllegalStateException(IllegalStateException e) {
            int errorCode = DataUtils.getErrorCode(e.getMessage());
            if (errorCode == 6) {
                if (this.encrypted) {
                    throw DbException.get(90049, e, this.fileName);
                }
            } else {
                if (errorCode == 7) {
                    throw DbException.get(90020, e, this.fileName);
                }
                if (errorCode == 1) {
                    throw DbException.get(90028, e, this.fileName);
                }
                if (errorCode == 3) {
                    throw DbException.get(50000, e, this.fileName);
                }
            }
            throw DbException.get(90030, e, this.fileName);
        }

        public MVStore getMvStore() {
            return this.mvStore;
        }

        public TransactionStore getTransactionStore() {
            return this.transactionStore;
        }

        public MVTable getTable(String tableName) {
            return this.tableMap.get(tableName);
        }

        public MVTable createTable(CreateTableData data) {
            MVTable table = new MVTable(data, this);
            this.tableMap.put(table.getMapName(), table);
            return table;
        }

        public void removeTable(MVTable table) {
            this.tableMap.remove(table.getMapName());
        }

        public void flush() {
            FileStore s = this.mvStore.getFileStore();
            if (s == null || s.isReadOnly()) {
                return;
            }
            if (!this.mvStore.compact(50, 0x400000)) {
                this.mvStore.commit();
            }
        }

        public void closeImmediately() {
            if (this.mvStore.isClosed()) {
                return;
            }
            this.mvStore.closeImmediately();
        }

        public void removeTemporaryMaps(BitSet objectIds) {
            for (String mapName : this.mvStore.getMapNames()) {
                int id;
                if (mapName.startsWith("temp.")) {
                    this.mvStore.removeMap(mapName);
                    continue;
                }
                if (!mapName.startsWith("table.") && !mapName.startsWith("index.") || objectIds.get(id = StringUtils.parseUInt31(mapName, mapName.indexOf(46) + 1, mapName.length()))) continue;
                this.mvStore.removeMap(mapName);
            }
        }

        public synchronized String nextTemporaryMapName() {
            return "temp." + this.temporaryMapId++;
        }

        public void prepareCommit(Session session, String transactionName) {
            Transaction t = session.getTransaction();
            t.setName(transactionName);
            t.prepare();
            this.mvStore.commit();
        }

        public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
            List<Transaction> list = this.transactionStore.getOpenTransactions();
            ArrayList<InDoubtTransaction> result = Utils.newSmallArrayList();
            for (Transaction t : list) {
                if (t.getStatus() != 2) continue;
                result.add(new MVInDoubtTransaction(this.mvStore, t));
            }
            return result;
        }

        public void setCacheSize(int kb) {
            this.mvStore.setCacheSize(Math.max(1, kb / 1024));
        }

        public InputStream getInputStream() {
            FileChannel fc = this.mvStore.getFileStore().getEncryptedFile();
            if (fc == null) {
                fc = this.mvStore.getFileStore().getFile();
            }
            return new FileChannelInputStream(fc, false);
        }

        public void sync() {
            this.flush();
            this.mvStore.sync();
        }

        public void compactFile(long maxCompactTime) {
            this.mvStore.setRetentionTime(0);
            long start = System.nanoTime();
            while (this.mvStore.compact(95, 0x1000000)) {
                this.mvStore.sync();
                this.mvStore.compactMoveChunks(95, 0x1000000L);
                long time = System.nanoTime() - start;
                if (time <= TimeUnit.MILLISECONDS.toNanos(maxCompactTime)) continue;
                break;
            }
        }

        public void close(boolean compactFully) {
            try {
                FileStore fileStore = this.mvStore.getFileStore();
                if (!this.mvStore.isClosed() && fileStore != null) {
                    if (fileStore.isReadOnly()) {
                        compactFully = false;
                    } else {
                        this.transactionStore.close();
                    }
                    String fileName = fileStore.getFileName();
                    this.mvStore.close();
                    if (compactFully && FileUtils.exists(fileName)) {
                        MVStoreTool.compact(fileName, true);
                    }
                }
            }
            catch (IllegalStateException e) {
                int errorCode = DataUtils.getErrorCode(e.getMessage());
                if (errorCode == 2 || errorCode == 6) {
                    // empty if block
                }
                this.mvStore.closeImmediately();
                throw DbException.get(90028, e, "Closing");
            }
        }

        public void statisticsStart() {
            FileStore fs = this.mvStore.getFileStore();
            this.statisticsStart = fs == null ? 0L : fs.getReadCount();
        }

        public Map<String, Integer> statisticsEnd() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            FileStore fs = this.mvStore.getFileStore();
            int reads = fs == null ? 0 : (int)(fs.getReadCount() - this.statisticsStart);
            map.put("reads", reads);
            return map;
        }
    }
}

