/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.gridgain.internal.h2.command.CommandInterface;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.expression.ParameterInterface;
import org.gridgain.internal.h2.jdbc.JdbcBatchUpdateException;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.jdbc.JdbcParameterMetaData;
import org.gridgain.internal.h2.jdbc.JdbcPreparedStatementBackwardsCompat;
import org.gridgain.internal.h2.jdbc.JdbcResultSet;
import org.gridgain.internal.h2.jdbc.JdbcResultSetMetaData;
import org.gridgain.internal.h2.jdbc.JdbcStatement;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.TraceObject;
import org.gridgain.internal.h2.result.MergedResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.ResultWithGeneratedKeys;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueByte;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.gridgain.internal.h2.value.ValueDouble;
import org.gridgain.internal.h2.value.ValueFloat;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueShort;
import org.gridgain.internal.h2.value.ValueString;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement,
JdbcPreparedStatementBackwardsCompat {
    protected CommandInterface command;
    private final String sqlStatement;
    private ArrayList<Value[]> batchParameters;
    private MergedResult batchIdentities;
    private HashMap<String, Integer> cachedColumnLabelMap;
    private final Object generatedKeysRequest;

    JdbcPreparedStatement(JdbcConnection conn, String sql, int id, int resultSetType, int resultSetConcurrency, boolean closeWithResultSet, Object generatedKeysRequest) {
        super(conn, id, resultSetType, resultSetConcurrency, closeWithResultSet);
        this.generatedKeysRequest = conn.scopeGeneratedKeys() ? Boolean.valueOf(false) : generatedKeysRequest;
        this.setTrace(this.session.getTrace(), 3, id);
        this.sqlStatement = sql;
        this.command = conn.prepareCommand(sql, this.fetchSize);
    }

    void setCachedColumnLabelMap(HashMap<String, Integer> cachedColumnLabelMap) {
        this.cachedColumnLabelMap = cachedColumnLabelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            int id = TraceObject.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, id, "executeQuery()");
            }
            this.batchIdentities = null;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface result;
                this.checkClosed();
                this.closeOldResultSet();
                boolean lazy = false;
                boolean scrollable = this.resultSetType != 1003;
                boolean updatable = this.resultSetConcurrency == 1008;
                try {
                    this.setExecutingStatement(this.command);
                    result = this.command.executeQuery(this.maxRows, scrollable);
                    lazy = result.isLazy();
                }
                finally {
                    if (!lazy) {
                        this.setExecutingStatement(null);
                    }
                }
                this.resultSet = new JdbcResultSet(this.conn, this, this.command, result, id, this.closedByResultSet, scrollable, updatable, this.cachedColumnLabelMap);
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        int n;
        this.debugCodeCall("executeUpdate");
        this.checkClosedForWrite();
        this.batchIdentities = null;
        try {
            n = this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception e) {
                throw this.logAndConvert(e);
            }
        }
        this.afterWriting();
        return n;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        long l;
        this.debugCodeCall("executeLargeUpdate");
        this.checkClosedForWrite();
        this.batchIdentities = null;
        try {
            l = this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception e) {
                throw this.logAndConvert(e);
            }
        }
        this.afterWriting();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOldResultSet();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                ResultWithGeneratedKeys result = this.command.executeUpdate(this.generatedKeysRequest);
                this.updateCount = result.getUpdateCount();
                ResultInterface gk = result.getGeneratedKeys();
                if (gk != null) {
                    int id = TraceObject.getNextId(4);
                    this.generatedKeys = new JdbcResultSet(this.conn, this, this.command, gk, id, false, true, false);
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean bl;
        int id = TraceObject.getNextId(4);
        if (this.isDebugEnabled()) {
            this.debugCodeCall("execute");
        }
        this.checkClosedForWrite();
        try {
            boolean returnsResultSet;
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                boolean lazy = false;
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        returnsResultSet = true;
                        boolean scrollable = this.resultSetType != 1003;
                        boolean updatable = this.resultSetConcurrency == 1008;
                        ResultInterface result = this.command.executeQuery(this.maxRows, scrollable);
                        lazy = result.isLazy();
                        this.resultSet = new JdbcResultSet(this.conn, this, this.command, result, id, this.closedByResultSet, scrollable, updatable, this.cachedColumnLabelMap);
                    } else {
                        returnsResultSet = false;
                        ResultWithGeneratedKeys result = this.command.executeUpdate(this.generatedKeysRequest);
                        this.updateCount = result.getUpdateCount();
                        ResultInterface gk = result.getGeneratedKeys();
                        if (gk != null) {
                            this.generatedKeys = new JdbcResultSet(this.conn, this, this.command, gk, id, false, true, false);
                        }
                    }
                }
                finally {
                    if (!lazy) {
                        this.setExecutingStatement(null);
                    }
                }
            }
            bl = returnsResultSet;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Throwable e) {
                throw this.logAndConvert(e);
            }
        }
        this.afterWriting();
        return bl;
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
            for (ParameterInterface parameterInterface : parameters) {
                parameterInterface.setValue(null, this.batchParameters == null);
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.debugCodeCall("addBatch", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.debugCodeCall("execute", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + parameterIndex + ", " + sqlType + ");");
            }
            this.setParameter(parameterIndex, ValueNull.INSTANCE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueInt.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + parameterIndex + ", " + TraceObject.quote(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueString.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + parameterIndex + ", " + TraceObject.quoteBigDecimal(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueDecimal.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + parameterIndex + ", " + TraceObject.quoteDate(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueDate.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + parameterIndex + ", " + TraceObject.quoteTime(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueTime.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + parameterIndex + ", " + TraceObject.quoteTimestamp(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, DataType.convertToValue(this.session, x, -1));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ");");
            }
            int type = DataType.convertSQLTypeToValueType(targetSqlType);
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                Value v = DataType.convertToValue(this.conn.getSession(), x, type);
                this.setParameter(parameterIndex, v.convertTo(type, this.conn.getMode()));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ", " + scale + ");");
            }
            this.setObject(parameterIndex, x, targetSqlType);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueBoolean.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueByte.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + parameterIndex + ", (short) " + x + ");");
            }
            this.setParameter(parameterIndex, ValueShort.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + parameterIndex + ", " + x + "L);");
            }
            this.setParameter(parameterIndex, ValueLong.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + parameterIndex + ", " + x + "f);");
            }
            this.setParameter(parameterIndex, ValueFloat.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + parameterIndex + ", " + x + "d);");
            }
            this.setParameter(parameterIndex, ValueDouble.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + parameterIndex + ", " + TraceObject.quoteDate(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, calendar != null ? DateTimeUtils.convertDate(x, calendar) : ValueDate.get(x));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + parameterIndex + ", " + TraceObject.quoteTime(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, calendar != null ? DateTimeUtils.convertTime(x, calendar) : ValueTime.get(x));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + parameterIndex + ", " + TraceObject.quoteTimestamp(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, calendar != null ? DateTimeUtils.convertTimestamp(x, calendar) : ValueTimestamp.get(x));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + parameterIndex + ", " + sqlType + ", " + TraceObject.quote(typeName) + ");");
            }
            this.setNull(parameterIndex, sqlType);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createBlob(x, -1L);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x, -1L);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setArray(" + parameterIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : DataType.convertToValue(this.session, x.getArray(), 17);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + parameterIndex + ", " + TraceObject.quoteBytes(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueBytes.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createBlob(x, length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setCharacterStream(parameterIndex, x, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createClob(x, length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface result = this.command.getMetaData();
            if (result == null) {
                return null;
            }
            int id = TraceObject.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, id, "getMetaData()");
            }
            String catalog = this.conn.getCatalog();
            return new JdbcResultSetMetaData(null, this, result, catalog, this.session.getTrace(), id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
            this.batchParameters = null;
            this.batchIdentities = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.debugCodeCall("executeBatch");
        if (this.batchParameters == null) {
            this.batchParameters = Utils.newSmallArrayList();
        }
        this.batchIdentities = new MergedResult();
        int size = this.batchParameters.size();
        int[] result = new int[size];
        boolean error = false;
        SQLException next = null;
        this.checkClosedForWrite();
        try {
            for (int i = 0; i < size; ++i) {
                Value[] set = this.batchParameters.get(i);
                ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
                for (int j = 0; j < set.length; ++j) {
                    Value value = set[j];
                    ParameterInterface param = parameters.get(j);
                    param.setValue(value, false);
                }
                try {
                    result[i] = this.executeUpdateInternal();
                    ResultSet rs = super.getGeneratedKeys();
                    this.batchIdentities.add(((JdbcResultSet)rs).result);
                    continue;
                }
                catch (Exception re) {
                    SQLException e = this.logAndConvert(re);
                    if (next == null) {
                        next = e;
                    } else {
                        e.setNextException(next);
                        next = e;
                    }
                    result[i] = -3;
                    error = true;
                }
            }
            this.batchParameters = null;
            if (error) {
                throw new JdbcBatchUpdateException(next, result);
            }
            nArray = result;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception e) {
                throw this.logAndConvert(e);
            }
        }
        this.afterWriting();
        return nArray;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchIdentities != null) {
            try {
                int id = TraceObject.getNextId(4);
                if (this.isDebugEnabled()) {
                    this.debugCodeAssign("ResultSet", 4, id, "getGeneratedKeys()");
                }
                this.checkClosed();
                this.generatedKeys = new JdbcResultSet(this.conn, this, null, this.batchIdentities.getResult(), id, false, true, false);
            }
            catch (Exception e) {
                throw this.logAndConvert(e);
            }
        }
        return super.getGeneratedKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosedForWrite();
            try {
                ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
                int size = parameters.size();
                Value[] set = new Value[size];
                for (int i = 0; i < size; ++i) {
                    Value value;
                    ParameterInterface param = parameters.get(i);
                    param.checkSet();
                    set[i] = value = param.getParamValue();
                }
                if (this.batchParameters == null) {
                    this.batchParameters = Utils.newSmallArrayList();
                }
                this.batchParameters.add(set);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + TraceObject.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + TraceObject.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + TraceObject.quote(sql) + ", " + TraceObject.quoteIntArray(columnIndexes) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + TraceObject.quote(sql) + ", " + TraceObject.quoteIntArray(columnIndexes) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + TraceObject.quote(sql) + ", " + TraceObject.quoteArray(columnNames) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + TraceObject.quote(sql) + ", " + TraceObject.quoteArray(columnNames) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + TraceObject.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + TraceObject.quote(sql) + ", " + TraceObject.quoteIntArray(columnIndexes) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + TraceObject.quote(sql) + ", " + TraceObject.quoteArray(columnNames) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int id = TraceObject.getNextId(11);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ParameterMetaData", 11, id, "getParameterMetaData()");
            }
            this.checkClosed();
            return new JdbcParameterMetaData(this.session.getTrace(), this, this.command, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void setParameter(int parameterIndex, Value value) {
        this.checkClosed();
        ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
        if (--parameterIndex < 0 || parameterIndex >= parameters.size()) {
            throw DbException.getInvalidValueException("parameterIndex", parameterIndex + 1);
        }
        ParameterInterface param = parameters.get(parameterIndex);
        param.setValue(value, this.batchParameters == null);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNString(" + parameterIndex + ", " + TraceObject.quote(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueString.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNCharacterStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createClob(x, length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setNCharacterStream(parameterIndex, x, -1L);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createClob(x, -1L);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createClob(x, length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createBlob(x, length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value v = this.conn.createClob(x, length);
                this.setParameter(parameterIndex, v);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setSQLXML(" + parameterIndex + ", x);");
            }
            this.checkClosedForWrite();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String toString() {
        return this.getTraceObjectName() + ": " + this.command;
    }

    @Override
    protected boolean checkClosed(boolean write) {
        if (super.checkClosed(write)) {
            ArrayList<? extends ParameterInterface> oldParams = this.command.getParameters();
            this.command = this.conn.prepareCommand(this.sqlStatement, this.fetchSize);
            ArrayList<? extends ParameterInterface> newParams = this.command.getParameters();
            int size = oldParams.size();
            for (int i = 0; i < size; ++i) {
                ParameterInterface old = oldParams.get(i);
                Value value = old.getParamValue();
                if (value == null) continue;
                ParameterInterface n = newParams.get(i);
                n.setValue(value, false);
            }
            return true;
        }
        return false;
    }
}

