/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.SelectGroups;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.analysis.PartitionData;
import org.gridgain.internal.h2.expression.analysis.Window;
import org.gridgain.internal.h2.expression.analysis.WindowFrame;
import org.gridgain.internal.h2.expression.analysis.WindowFrameBound;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;

public abstract class DataAnalysisOperation
extends Expression {
    public static final int STAGE_RESET = 0;
    public static final int STAGE_GROUP = 1;
    public static final int STAGE_WINDOW = 2;
    protected final Select select;
    protected Window over;
    protected SortOrder overOrderBySort;
    private int numFrameExpressions;
    private int lastGroupRowId;

    protected static SortOrder createOrder(Session session, ArrayList<SelectOrderBy> orderBy, int offset) {
        int size = orderBy.size();
        int[] index = new int[size];
        int[] sortType = new int[size];
        for (int i = 0; i < size; ++i) {
            SelectOrderBy o = orderBy.get(i);
            index[i] = i + offset;
            sortType[i] = o.sortType;
        }
        return new SortOrder(session.getDatabase(), index, sortType, null, null);
    }

    protected DataAnalysisOperation(Select select) {
        this.select = select;
    }

    public void setOverCondition(Window over) {
        this.over = over;
    }

    public abstract boolean isAggregate();

    protected SortOrder getOverOrderBySort() {
        return this.overOrderBySort;
    }

    @Override
    public final void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.over != null) {
            if (state != 0) {
                throw DbException.get(90054, this.getSQL(false));
            }
            state = 1;
        } else {
            if (state == 2) {
                throw DbException.get(90054, this.getSQL(false));
            }
            state = 2;
        }
        this.mapColumnsAnalysis(resolver, level, state);
    }

    protected void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        if (this.over != null) {
            this.over.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.over != null) {
            this.over.optimize(session);
            ArrayList<SelectOrderBy> orderBy = this.over.getOrderBy();
            if (orderBy != null) {
                this.overOrderBySort = DataAnalysisOperation.createOrder(session, orderBy, this.getNumExpressions());
            } else if (!this.isAggregate()) {
                this.overOrderBySort = new SortOrder(session.getDatabase(), new int[this.getNumExpressions()], new int[0], null, null);
            }
            WindowFrame frame = this.over.getWindowFrame();
            if (frame != null) {
                int index = this.getNumExpressions();
                int orderBySize = 0;
                if (orderBy != null) {
                    orderBySize = orderBy.size();
                    index += orderBySize;
                }
                int n = 0;
                WindowFrameBound bound = frame.getStarting();
                if (bound.isParameterized()) {
                    if (orderBySize != 1) {
                        throw this.getSingleSortKeyException();
                    }
                    if (bound.isVariable()) {
                        bound.setExpressionIndex(index);
                        ++n;
                    }
                }
                if ((bound = frame.getFollowing()) != null && bound.isParameterized()) {
                    if (orderBySize != 1) {
                        throw this.getSingleSortKeyException();
                    }
                    if (bound.isVariable()) {
                        bound.setExpressionIndex(index + n);
                        ++n;
                    }
                }
                this.numFrameExpressions = n;
            }
        }
        return this;
    }

    private DbException getSingleSortKeyException() {
        String sql = this.getSQL(false);
        return DbException.getSyntaxError(sql, sql.length() - 1, "exactly one sort key is required for RANGE units");
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.over != null) {
            this.over.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public final void updateAggregate(Session session, int stage) {
        if (stage == 0) {
            this.updateGroupAggregates(session, 0);
            this.lastGroupRowId = 0;
            return;
        }
        boolean window = stage == 2;
        if (window != (this.over != null)) {
            if (!window && this.select.isWindowQuery()) {
                this.updateGroupAggregates(session, stage);
            }
            return;
        }
        SelectGroups groupData = this.select.getGroupDataIfCurrent(window);
        if (groupData == null) {
            return;
        }
        int groupRowId = groupData.getCurrentGroupRowId();
        if (this.lastGroupRowId == groupRowId) {
            return;
        }
        this.lastGroupRowId = groupRowId;
        if (this.over != null && !this.select.isGroupQuery()) {
            this.over.updateAggregate(session, stage);
        }
        this.updateAggregate(session, groupData, groupRowId);
    }

    protected abstract void updateAggregate(Session var1, SelectGroups var2, int var3);

    protected void updateGroupAggregates(Session session, int stage) {
        if (this.over != null) {
            this.over.updateAggregate(session, stage);
        }
    }

    protected abstract int getNumExpressions();

    private int getNumFrameExpressions() {
        return this.numFrameExpressions;
    }

    protected abstract void rememberExpressions(Session var1, Value[] var2);

    protected Object getWindowData(Session session, SelectGroups groupData, boolean forOrderBy) {
        Object data;
        Value key = this.over.getCurrentKey(session);
        PartitionData partition = groupData.getWindowExprData(this, key);
        if (partition == null) {
            data = forOrderBy ? new ArrayList() : this.createAggregateData();
            groupData.setWindowExprData(this, key, new PartitionData(data));
        } else {
            data = partition.getData();
        }
        return data;
    }

    protected Object getGroupData(SelectGroups groupData, boolean ifExists) {
        Object data = groupData.getCurrentGroupExprData(this);
        if (data == null) {
            if (ifExists) {
                return null;
            }
            data = this.createAggregateData();
            groupData.setCurrentGroupExprData(this, data);
        }
        return data;
    }

    protected abstract Object createAggregateData();

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (this.over == null) {
            return true;
        }
        switch (visitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public Value getValue(Session session) {
        SelectGroups groupData = this.select.getGroupDataIfCurrent(this.over != null);
        if (groupData == null) {
            throw DbException.get(90054, this.getSQL(false));
        }
        return this.over == null ? this.getAggregatedValue(session, this.getGroupData(groupData, true)) : this.getWindowResult(session, groupData);
    }

    private Value getWindowResult(Session session, SelectGroups groupData) {
        Object data;
        boolean forOrderBy = this.over.getOrderBy() != null;
        Value key = this.over.getCurrentKey(session);
        PartitionData partition = groupData.getWindowExprData(this, key);
        if (partition == null) {
            data = forOrderBy ? new ArrayList() : this.createAggregateData();
            partition = new PartitionData(data);
            groupData.setWindowExprData(this, key, partition);
        } else {
            data = partition.getData();
        }
        if (forOrderBy || !this.isAggregate()) {
            Value result = this.getOrderedResult(session, groupData, partition, data);
            if (result == null) {
                return this.getAggregatedValue(session, null);
            }
            return result;
        }
        Value result = partition.getResult();
        if (result == null) {
            result = this.getAggregatedValue(session, data);
            partition.setResult(result);
        }
        return result;
    }

    protected abstract Value getAggregatedValue(Session var1, Object var2);

    protected void updateOrderedAggregate(Session session, SelectGroups groupData, int groupRowId, ArrayList<SelectOrderBy> orderBy) {
        int ne = this.getNumExpressions();
        int size = orderBy != null ? orderBy.size() : 0;
        int frameSize = this.getNumFrameExpressions();
        Value[] array = new Value[ne + size + frameSize + 1];
        this.rememberExpressions(session, array);
        for (int i = 0; i < size; ++i) {
            SelectOrderBy o = orderBy.get(i);
            array[ne++] = o.expression.getValue(session);
        }
        if (frameSize > 0) {
            WindowFrame frame = this.over.getWindowFrame();
            WindowFrameBound bound = frame.getStarting();
            if (bound.isVariable()) {
                array[ne++] = bound.getValue().getValue(session);
            }
            if ((bound = frame.getFollowing()) != null && bound.isVariable()) {
                array[ne++] = bound.getValue().getValue(session);
            }
        }
        array[ne] = ValueInt.get(groupRowId);
        ArrayList data = (ArrayList)this.getWindowData(session, groupData, true);
        data.add(array);
    }

    private Value getOrderedResult(Session session, SelectGroups groupData, PartitionData partition, Object data) {
        HashMap<Integer, Value> result = partition.getOrderedResult();
        if (result == null) {
            result = new HashMap();
            ArrayList orderedData = (ArrayList)data;
            int rowIdColumn = this.getNumExpressions();
            ArrayList<SelectOrderBy> orderBy = this.over.getOrderBy();
            if (orderBy != null) {
                rowIdColumn += orderBy.size();
                Collections.sort(orderedData, this.overOrderBySort);
            }
            this.getOrderedResultLoop(session, result, orderedData, rowIdColumn += this.getNumFrameExpressions());
            partition.setOrderedResult(result);
        }
        return result.get(groupData.getCurrentGroupRowId());
    }

    protected abstract void getOrderedResultLoop(Session var1, HashMap<Integer, Value> var2, ArrayList<Value[]> var3, int var4);

    protected StringBuilder appendTailConditions(StringBuilder builder, boolean alwaysQuote) {
        if (this.over != null) {
            builder.append(' ');
            this.over.getSQL(builder, alwaysQuote);
        }
        return builder;
    }
}

