/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;

public abstract class DbObjectBase
implements DbObject {
    protected Database database;
    protected Trace trace;
    protected String comment;
    private int id;
    private String objectName;
    private long modificationId;
    private boolean temporary;

    protected DbObjectBase(Database db, int objectId, String name, int traceModuleId) {
        this.database = db;
        this.trace = db.getTrace(traceModuleId);
        this.id = objectId;
        this.objectName = name;
        this.modificationId = db.getModificationMetaId();
    }

    @Override
    public abstract String getCreateSQL();

    @Override
    public abstract String getDropSQL();

    @Override
    public abstract void removeChildrenAndResources(Session var1);

    @Override
    public abstract void checkRename();

    public void setModified() {
        this.modificationId = this.database == null ? -1L : this.database.getNextModificationMetaId();
    }

    public long getModificationId() {
        return this.modificationId;
    }

    protected void setObjectName(String name) {
        this.objectName = name;
    }

    @Override
    public String getSQL(boolean alwaysQuote) {
        return Parser.quoteIdentifier(this.objectName, alwaysQuote);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        return Parser.quoteIdentifier(builder, this.objectName, alwaysQuote);
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        return null;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.objectName;
    }

    protected void invalidate() {
        if (this.id == -1) {
            throw DbException.throwInternalError();
        }
        this.setModified();
        this.id = -1;
        this.database = null;
        this.trace = null;
        this.objectName = null;
    }

    public final boolean isValid() {
        return this.id != -1;
    }

    @Override
    public void rename(String newName) {
        this.checkRename();
        this.objectName = newName;
        this.setModified();
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return this.objectName + ":" + this.id + ":" + super.toString();
    }
}

