/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueFloat
extends Value {
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    public static final int ZERO_BITS = 0;
    public static final ValueFloat ZERO = new ValueFloat(0.0f);
    public static final ValueFloat ONE = new ValueFloat(1.0f);
    private static final ValueFloat NAN = new ValueFloat(Float.NaN);
    private final float value;

    private ValueFloat(float value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value + v2.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value - v2.value);
    }

    @Override
    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        return ValueFloat.get(this.value * v2.value);
    }

    @Override
    public Value divide(Value v) {
        ValueFloat v2 = (ValueFloat)v;
        if ((double)v2.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / v2.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueFloat other = (ValueFloat)v;
        if (other.value == 0.0f) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        if (this.value == Float.POSITIVE_INFINITY) {
            builder.append("POWER(0, -1)");
        } else if (this.value == Float.NEGATIVE_INFINITY) {
            builder.append("(-POWER(0, -1))");
        } else if (Float.isNaN(this.value)) {
            builder.append("SQRT(-1)");
        } else {
            builder.append(this.value);
        }
        return builder;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_FLOAT;
    }

    @Override
    public int getValueType() {
        return 8;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Float.compare(this.value, ((ValueFloat)o).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Math.abs(this.value) <= Float.MAX_VALUE) {
            return new BigDecimal(Float.toString(this.value));
        }
        throw DbException.get(22018, Float.toString(this.value));
    }

    @Override
    public String getString() {
        return Float.toString(this.value);
    }

    @Override
    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setFloat(parameterIndex, this.value);
    }

    public static ValueFloat get(float d) {
        if (d == 1.0f) {
            return ONE;
        }
        if (d == 0.0f) {
            return ZERO;
        }
        if (Float.isNaN(d)) {
            return NAN;
        }
        return (ValueFloat)Value.cache(new ValueFloat(d));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueFloat)) {
            return false;
        }
        return this.compareTypeSafe((ValueFloat)other, null) == 0;
    }
}

