/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.security.CipherFactory;

public class NetUtils {
    private static final int CACHE_MILLIS = 1000;
    private static InetAddress cachedBindAddress;
    private static String cachedLocalAddress;
    private static long cachedLocalAddressTime;

    private NetUtils() {
    }

    public static Socket createLoopbackSocket(int port, boolean ssl) throws IOException {
        String local = NetUtils.getLocalAddress();
        try {
            return NetUtils.createSocket(local, port, ssl);
        }
        catch (IOException e) {
            try {
                return NetUtils.createSocket("localhost", port, ssl);
            }
            catch (IOException e2) {
                throw e;
            }
        }
    }

    public static Socket createSocket(String server, int defaultPort, boolean ssl) throws IOException {
        int port = defaultPort;
        int startIndex = server.startsWith("[") ? server.indexOf(93) : 0;
        int idx = server.indexOf(58, startIndex);
        if (idx >= 0) {
            port = Integer.decode(server.substring(idx + 1));
            server = server.substring(0, idx);
        }
        InetAddress address = InetAddress.getByName(server);
        return NetUtils.createSocket(address, port, ssl);
    }

    public static Socket createSocket(InetAddress address, int port, boolean ssl) throws IOException {
        long start = System.nanoTime();
        int i = 0;
        while (true) {
            try {
                if (ssl) {
                    return CipherFactory.createSocket(address, port);
                }
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(address, port), SysProperties.SOCKET_CONNECT_TIMEOUT);
                return socket;
            }
            catch (IOException e) {
                if (System.nanoTime() - start >= TimeUnit.MILLISECONDS.toNanos(SysProperties.SOCKET_CONNECT_TIMEOUT)) {
                    throw e;
                }
                if (i >= SysProperties.SOCKET_CONNECT_RETRY) {
                    throw e;
                }
                try {
                    long sleep = Math.min(256, i * i);
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public static ServerSocket createServerSocket(int port, boolean ssl) {
        try {
            return NetUtils.createServerSocketTry(port, ssl);
        }
        catch (Exception e) {
            return NetUtils.createServerSocketTry(port, ssl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getBindAddress() throws UnknownHostException {
        String host = SysProperties.BIND_ADDRESS;
        if (host == null || host.isEmpty()) {
            return null;
        }
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (cachedBindAddress == null) {
                cachedBindAddress = InetAddress.getByName(host);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cachedBindAddress;
        }
    }

    private static ServerSocket createServerSocketTry(int port, boolean ssl) {
        try {
            InetAddress bindAddress = NetUtils.getBindAddress();
            if (ssl) {
                return CipherFactory.createServerSocket(port, bindAddress);
            }
            if (bindAddress == null) {
                return new ServerSocket(port);
            }
            return new ServerSocket(port, 0, bindAddress);
        }
        catch (BindException be) {
            throw DbException.get(90061, be, Integer.toString(port), be.toString());
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "port: " + port + " ssl: " + ssl);
        }
    }

    public static boolean isLocalAddress(Socket socket) throws UnknownHostException {
        InetAddress test = socket.getInetAddress();
        if (test.isLoopbackAddress()) {
            return true;
        }
        InetAddress localhost = InetAddress.getLocalHost();
        String host = localhost.getHostAddress();
        for (InetAddress addr : InetAddress.getAllByName(host)) {
            if (!test.equals(addr)) continue;
            return true;
        }
        return false;
    }

    public static ServerSocket closeSilently(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized String getLocalAddress() {
        String address;
        long now = System.nanoTime();
        if (cachedLocalAddress != null && cachedLocalAddressTime + TimeUnit.MILLISECONDS.toNanos(1000L) > now) {
            return cachedLocalAddress;
        }
        InetAddress bind = null;
        boolean useLocalhost = false;
        try {
            bind = NetUtils.getBindAddress();
            if (bind == null) {
                useLocalhost = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (useLocalhost) {
            try {
                bind = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw DbException.convert(e);
            }
        }
        if (bind == null) {
            address = "localhost";
        } else {
            address = bind.getHostAddress();
            if (bind instanceof Inet6Address) {
                if (address.indexOf(37) >= 0) {
                    address = "localhost";
                } else if (address.indexOf(58) >= 0 && !address.startsWith("[")) {
                    address = "[" + address + "]";
                }
            }
        }
        if (address.equals("127.0.0.1")) {
            address = "localhost";
        }
        cachedLocalAddress = address;
        cachedLocalAddressTime = now;
        return address;
    }

    public static String getHostName(String localAddress) {
        try {
            InetAddress addr = InetAddress.getByName(localAddress);
            return addr.getHostName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

