/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.tx;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.gridgain.internal.h2.mvstore.Cursor;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.WriteBuffer;
import org.gridgain.internal.h2.mvstore.tx.CommitDecisionMaker;
import org.gridgain.internal.h2.mvstore.tx.RollbackDecisionMaker;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionMap;
import org.gridgain.internal.h2.mvstore.tx.VersionedBitSet;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueType;
import org.gridgain.internal.h2.mvstore.type.DataType;
import org.gridgain.internal.h2.mvstore.type.ObjectDataType;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.VersionedValue;

public class TransactionStore {
    final MVStore store;
    private final int timeoutMillis;
    private final MVMap<Integer, Object[]> preparedTransactions;
    final MVMap<Long, Object[]>[] undoLogs = new MVMap[65535];
    private final MVMap.Builder<Long, Object[]> undoLogBuilder;
    private final MVMap.Builder<Object, VersionedValue> mapBuilder;
    final AtomicReference<VersionedBitSet> openTransactions = new AtomicReference<VersionedBitSet>(new VersionedBitSet());
    final AtomicReference<BitSet> committingTransactions = new AtomicReference<BitSet>(new BitSet());
    private boolean init;
    private int maxTransactionId = 65535;
    private final AtomicReferenceArray<Transaction> transactions = new AtomicReferenceArray(65536);
    private static final String UNDO_LOG_NAME_PREFIX = "undoLog";
    private static final char UNDO_LOG_COMMITTED = '-';
    private static final char UNDO_LOG_OPEN = '.';
    private static final int MAX_OPEN_TRANSACTIONS = 65535;
    private static final int LOG_ID_BITS = 40;
    private static final long LOG_ID_MASK = 0xFFFFFFFFFFL;
    private static final RollbackListener ROLLBACK_LISTENER_NONE = new RollbackListener(){

        @Override
        public void onRollback(MVMap<Object, VersionedValue> map, Object key, VersionedValue existingValue, VersionedValue restoredValue) {
        }
    };

    public static String getUndoLogName(boolean committed, int transactionId) {
        return UNDO_LOG_NAME_PREFIX + (committed ? (char)'-' : '.') + (transactionId > 0 ? String.valueOf(transactionId) : "");
    }

    public TransactionStore(MVStore store) {
        this(store, new ObjectDataType(), 0);
    }

    public TransactionStore(MVStore store, DataType dataType, int timeoutMillis) {
        this.store = store;
        this.timeoutMillis = timeoutMillis;
        this.preparedTransactions = store.openMap("openTransactions", new MVMap.Builder());
        VersionedValueType oldValueType = new VersionedValueType(dataType);
        ArrayType undoLogValueType = new ArrayType(new DataType[]{new ObjectDataType(), dataType, oldValueType});
        this.undoLogBuilder = new MVMap.Builder().singleWriter().valueType(undoLogValueType);
        VersionedValueType vt = new VersionedValueType(dataType);
        this.mapBuilder = ((MVMap.Builder)new MVMap.Builder().keyType(dataType)).valueType(vt);
    }

    public void init() {
        if (!this.init) {
            for (String mapName : this.store.getMapNames()) {
                if (!mapName.startsWith(UNDO_LOG_NAME_PREFIX)) continue;
                if (mapName.length() > UNDO_LOG_NAME_PREFIX.length()) {
                    boolean committed;
                    boolean bl = committed = mapName.charAt(UNDO_LOG_NAME_PREFIX.length()) == '-';
                    if (this.store.hasData(mapName) || committed) {
                        int transactionId = StringUtils.parseUInt31(mapName, UNDO_LOG_NAME_PREFIX.length() + 1, mapName.length());
                        VersionedBitSet openTxBitSet = this.openTransactions.get();
                        if (!openTxBitSet.get(transactionId)) {
                            String name;
                            int status;
                            Object[] data = this.preparedTransactions.get(transactionId);
                            if (data == null) {
                                status = 1;
                                name = null;
                            } else {
                                status = (Integer)data[0];
                                name = (String)data[1];
                            }
                            if (committed) {
                                status = 3;
                            }
                            Object undoLog = this.store.openMap(mapName, this.undoLogBuilder);
                            this.undoLogs[transactionId] = undoLog;
                            Long lastUndoKey = (Long)((MVMap)undoLog).lastKey();
                            assert (committed || lastUndoKey != null);
                            assert (committed || TransactionStore.getTransactionId(lastUndoKey) == transactionId);
                            long logId = lastUndoKey == null ? 0L : TransactionStore.getLogId(lastUndoKey) + 1L;
                            this.registerTransaction(transactionId, status, name, logId, this.timeoutMillis, 0, ROLLBACK_LISTENER_NONE);
                            continue;
                        }
                    }
                }
                if (this.store.isReadOnly()) continue;
                this.store.removeMap(mapName);
            }
            this.init = true;
        }
    }

    public void endLeftoverTransactions() {
        List<Transaction> list = this.getOpenTransactions();
        for (Transaction t : list) {
            int status = t.getStatus();
            if (status == 3) {
                t.commit();
                continue;
            }
            if (status == 2) continue;
            t.rollback();
        }
    }

    public void setMaxTransactionId(int max) {
        DataUtils.checkArgument(max <= 65535, "Concurrent transactions limit is too high: {0}", max);
        this.maxTransactionId = max;
    }

    public boolean hasMap(String name) {
        return this.store.hasMap(name);
    }

    static long getOperationId(int transactionId, long logId) {
        DataUtils.checkArgument(transactionId >= 0 && transactionId < 0x1000000, "Transaction id out of range: {0}", transactionId);
        DataUtils.checkArgument(logId >= 0L && logId <= 0xFFFFFFFFFFL, "Transaction log id out of range: {0}", logId);
        return (long)transactionId << 40 | logId;
    }

    static int getTransactionId(long operationId) {
        return (int)(operationId >>> 40);
    }

    static long getLogId(long operationId) {
        return operationId & 0xFFFFFFFFFFL;
    }

    public List<Transaction> getOpenTransactions() {
        if (!this.init) {
            this.init();
        }
        ArrayList<Transaction> list = new ArrayList<Transaction>();
        int transactionId = 0;
        BitSet bitSet = this.openTransactions.get();
        while ((transactionId = bitSet.nextSetBit(transactionId + 1)) > 0) {
            Transaction transaction = this.getTransaction(transactionId);
            if (transaction == null || transaction.getStatus() == 0) continue;
            list.add(transaction);
        }
        return list;
    }

    public synchronized void close() {
        this.store.commit();
    }

    public Transaction begin() {
        return this.begin(ROLLBACK_LISTENER_NONE, this.timeoutMillis, 0);
    }

    public Transaction begin(RollbackListener listener, int timeoutMillis, int ownerId) {
        if (timeoutMillis <= 0) {
            timeoutMillis = this.timeoutMillis;
        }
        Transaction transaction = this.registerTransaction(0, 1, null, 0L, timeoutMillis, ownerId, listener);
        return transaction;
    }

    private Transaction registerTransaction(int txId, int status, String name, long logId, int timeoutMillis, int ownerId, RollbackListener listener) {
        long sequenceNo;
        int transactionId;
        VersionedBitSet clone;
        VersionedBitSet original;
        boolean success;
        do {
            original = this.openTransactions.get();
            if (txId == 0) {
                transactionId = original.nextClearBit(1);
            } else {
                transactionId = txId;
                assert (!original.get(transactionId));
            }
            if (transactionId > this.maxTransactionId) {
                throw DataUtils.newIllegalStateException(102, "There are {0} open transactions", transactionId - 1);
            }
            clone = original.clone();
            clone.set(transactionId);
            sequenceNo = clone.getVersion() + 1L;
            clone.setVersion(sequenceNo);
        } while (!(success = this.openTransactions.compareAndSet(original, clone)));
        Transaction transaction = new Transaction(this, transactionId, sequenceNo, status, name, logId, timeoutMillis, ownerId, listener);
        assert (this.transactions.get(transactionId) == null);
        this.transactions.set(transactionId, transaction);
        if (this.undoLogs[transactionId] == null) {
            String undoName = TransactionStore.getUndoLogName(status == 3, transactionId);
            Object undoLog = this.store.openMap(undoName, this.undoLogBuilder);
            this.undoLogs[transactionId] = undoLog;
        }
        return transaction;
    }

    void storeTransaction(Transaction t) {
        if (t.getStatus() == 2 || t.getName() != null) {
            Object[] v = new Object[]{t.getStatus(), t.getName()};
            this.preparedTransactions.put(t.getId(), v);
            t.wasStored = true;
        }
    }

    long addUndoLogRecord(int transactionId, long logId, Object[] undoLogRecord) {
        MVMap<Long, Object[]> undoLog = this.undoLogs[transactionId];
        long undoKey = TransactionStore.getOperationId(transactionId, logId);
        if (logId == 0L && !undoLog.isEmpty()) {
            throw DataUtils.newIllegalStateException(102, "An old transaction with the same id is still open: {0}", transactionId);
        }
        undoLog.append(undoKey, undoLogRecord);
        return undoKey;
    }

    void removeUndoLogRecord(int transactionId) {
        this.undoLogs[transactionId].trimLast();
    }

    <K, V> void removeMap(TransactionMap<K, V> map) {
        this.store.removeMap(map.map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction t, boolean recovery) {
        if (!this.store.isClosed()) {
            int transactionId = t.transactionId;
            this.flipCommittingTransactionsBit(transactionId, true);
            CommitDecisionMaker commitDecisionMaker = new CommitDecisionMaker();
            try {
                MVMap<Long, Object[]> undoLog = this.undoLogs[transactionId];
                if (!recovery) {
                    this.store.renameMap(undoLog, TransactionStore.getUndoLogName(true, transactionId));
                }
                try {
                    Cursor<Object, Object[]> cursor = undoLog.cursor(null);
                    while (cursor.hasNext()) {
                        Long undoKey = cursor.next();
                        Object[] op = cursor.getValue();
                        int mapId = (Integer)op[0];
                        MVMap<Object, VersionedValue> map = this.openMap(mapId);
                        if (map == null) continue;
                        Object key = op[1];
                        commitDecisionMaker.setUndoKey(undoKey);
                        map.operate(key, VersionedValue.DUMMY, commitDecisionMaker);
                    }
                    undoLog.clear();
                }
                finally {
                    this.store.renameMap(undoLog, TransactionStore.getUndoLogName(false, transactionId));
                }
            }
            finally {
                this.flipCommittingTransactionsBit(transactionId, false);
            }
        }
    }

    private void flipCommittingTransactionsBit(int transactionId, boolean flag) {
        BitSet clone;
        BitSet original;
        boolean success;
        do {
            original = this.committingTransactions.get();
            assert (original.get(transactionId) != flag) : flag ? "Double commit" : "Mysterious bit's disappearance";
            clone = (BitSet)original.clone();
            clone.set(transactionId, flag);
        } while (!(success = this.committingTransactions.compareAndSet(original, clone)));
    }

    <K> MVMap<K, VersionedValue> openMap(String name, DataType keyType, DataType valueType) {
        if (keyType == null) {
            keyType = new ObjectDataType();
        }
        if (valueType == null) {
            valueType = new ObjectDataType();
        }
        VersionedValueType vt = new VersionedValueType(valueType);
        MVMap.BasicBuilder builder = ((MVMap.Builder)new MVMap.Builder().keyType(keyType)).valueType(vt);
        Object map = this.store.openMap(name, builder);
        return map;
    }

    MVMap<Object, VersionedValue> openMap(int mapId) {
        MVMap<Object, VersionedValue> map = this.store.getMap(mapId);
        if (map == null) {
            String mapName = this.store.getMapName(mapId);
            if (mapName == null) {
                return null;
            }
            map = this.store.openMap(mapName, this.mapBuilder);
        }
        return map;
    }

    void endTransaction(Transaction t, boolean hasChanges) {
        VersionedBitSet clone;
        VersionedBitSet original;
        boolean success;
        t.closeIt();
        int txId = t.transactionId;
        this.transactions.set(txId, null);
        do {
            original = this.openTransactions.get();
            assert (original.get(txId));
            clone = original.clone();
            clone.clear(txId);
        } while (!(success = this.openTransactions.compareAndSet(original, clone)));
        if (hasChanges) {
            int max;
            int unsaved;
            boolean wasStored = t.wasStored;
            if (wasStored && !this.preparedTransactions.isClosed()) {
                this.preparedTransactions.remove(txId);
            }
            if (wasStored || this.store.getAutoCommitDelay() == 0) {
                this.store.tryCommit();
            } else if (this.isUndoEmpty() && (unsaved = this.store.getUnsavedMemory()) * 4 > (max = this.store.getAutoCommitMemory()) * 3) {
                this.store.tryCommit();
            }
        }
    }

    private boolean isUndoEmpty() {
        BitSet openTrans = this.openTransactions.get();
        int i = openTrans.nextSetBit(0);
        while (i >= 0) {
            MVMap<Long, Object[]> undoLog = this.undoLogs[i];
            if (undoLog != null && !undoLog.isEmpty()) {
                return false;
            }
            i = openTrans.nextSetBit(i + 1);
        }
        return true;
    }

    Transaction getTransaction(int transactionId) {
        return this.transactions.get(transactionId);
    }

    void rollbackTo(Transaction t, long maxLogId, long toLogId) {
        int transactionId = t.getId();
        MVMap<Long, Object[]> undoLog = this.undoLogs[transactionId];
        RollbackDecisionMaker decisionMaker = new RollbackDecisionMaker(this, transactionId, toLogId, t.listener);
        for (long logId = maxLogId - 1L; logId >= toLogId; --logId) {
            Long undoKey = TransactionStore.getOperationId(transactionId, logId);
            undoLog.operate(undoKey, null, decisionMaker);
            decisionMaker.reset();
        }
    }

    Iterator<Change> getChanges(final Transaction t, final long maxLogId, final long toLogId) {
        final MVMap<Long, Object[]> undoLog = this.undoLogs[t.getId()];
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = maxLogId - 1L;
            }

            private void fetchNext() {
                int transactionId = t.getId();
                while (this.logId >= toLogId) {
                    Long undoKey = TransactionStore.getOperationId(transactionId, this.logId);
                    Object[] op = (Object[])undoLog.get(undoKey);
                    --this.logId;
                    if (op == null) {
                        if ((undoKey = undoLog.floorKey(undoKey)) == null || TransactionStore.getTransactionId(undoKey) != transactionId) break;
                        this.logId = TransactionStore.getLogId(undoKey);
                        continue;
                    }
                    int mapId = (Integer)op[0];
                    MVMap<Object, VersionedValue> m = TransactionStore.this.openMap(mapId);
                    if (m == null) continue;
                    VersionedValue oldValue = (VersionedValue)op[2];
                    this.current = new Change(m.getName(), op[1], oldValue == null ? null : oldValue.getCurrentValue());
                    return;
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.fetchNext();
                }
                return this.current != null;
            }

            @Override
            public Change next() {
                if (!this.hasNext()) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change result = this.current;
                this.current = null;
                return result;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public static class ArrayType
    implements DataType {
        private final int arrayLength;
        private final DataType[] elementTypes;

        ArrayType(DataType[] elementTypes) {
            this.arrayLength = elementTypes.length;
            this.elementTypes = elementTypes;
        }

        @Override
        public int getMemory(Object obj) {
            Object[] array = (Object[])obj;
            int size = 0;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                Object o = array[i];
                if (o == null) continue;
                size += t.getMemory(o);
            }
            return size;
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj == bObj) {
                return 0;
            }
            Object[] a = (Object[])aObj;
            Object[] b = (Object[])bObj;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                int comp = t.compare(a[i], b[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }

        @Override
        public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < len; ++i) {
                obj[i] = this.read(buff);
            }
        }

        @Override
        public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < len; ++i) {
                this.write(buff, obj[i]);
            }
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            Object[] array = (Object[])obj;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                Object o = array[i];
                if (o == null) {
                    buff.put((byte)0);
                    continue;
                }
                buff.put((byte)1);
                t.write(buff, o);
            }
        }

        @Override
        public Object read(ByteBuffer buff) {
            Object[] array = new Object[this.arrayLength];
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType t = this.elementTypes[i];
                if (buff.get() != 1) continue;
                array[i] = t.read(buff);
            }
            return array;
        }
    }

    public static interface RollbackListener {
        public void onRollback(MVMap<Object, VersionedValue> var1, Object var2, VersionedValue var3, VersionedValue var4);
    }

    public static class Change {
        public final String mapName;
        public final Object key;
        public final Object value;

        public Change(String mapName, Object key, Object value) {
            this.mapName = mapName;
            this.key = key;
            this.value = value;
        }
    }
}

