/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.Cursor;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.db.MVTempResult;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.result.ResultExternal;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

class MVPlainTempResult
extends MVTempResult {
    private final MVMap<Long, ValueRow> map;
    private long counter;
    private Cursor<Long, ValueRow> cursor;

    private MVPlainTempResult(MVPlainTempResult parent) {
        super(parent);
        this.map = parent.map;
    }

    MVPlainTempResult(Database database, Expression[] expressions, int visibleColumnCount) {
        super(database, expressions, visibleColumnCount);
        ValueDataType valueType = new ValueDataType(database, new int[expressions.length]);
        MVMap.Builder builder = ((MVMap.Builder)new MVMap.Builder().valueType(valueType)).singleWriter();
        this.map = this.store.openMap("tmp", builder);
    }

    @Override
    public int addRow(Value[] values) {
        assert (this.parent == null);
        this.map.append(this.counter++, ValueRow.get(values));
        return ++this.rowCount;
    }

    @Override
    public boolean contains(Value[] values) {
        throw DbException.getUnsupportedException("contains()");
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new MVPlainTempResult(this);
    }

    @Override
    public Value[] next() {
        if (this.cursor == null) {
            this.cursor = this.map.cursor(null);
        }
        if (!this.cursor.hasNext()) {
            return null;
        }
        this.cursor.next();
        Value[] currentRow = this.cursor.getValue().getList();
        if (this.hasEnum) {
            this.fixEnum(currentRow);
        }
        return currentRow;
    }

    @Override
    public int removeRow(Value[] values) {
        throw DbException.getUnsupportedException("removeRow()");
    }

    @Override
    public void reset() {
        this.cursor = null;
    }
}

