/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gridgain.internal.h2.command.ddl.SchemaCommand;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.constraint.ConstraintActionType;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.StringUtils;

public class DropTable
extends SchemaCommand {
    private boolean ifExists;
    private String tableName;
    private Table table;
    private DropTable next;
    private ConstraintActionType dropAction;

    public DropTable(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void addNextDropTable(DropTable drop) {
        if (this.next == null) {
            this.next = drop;
        } else {
            this.next.addNextDropTable(drop);
        }
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
        if (this.next != null) {
            this.next.setIfExists(b);
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private void prepareDrop() {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table == null) {
            if (!this.ifExists) {
                throw DbException.get(42102, this.tableName);
            }
        } else {
            this.session.getUser().checkRight(this.table, 15);
            if (!this.table.canDrop()) {
                throw DbException.get(90118, this.tableName);
            }
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                ArrayList<Constraint> constraints;
                ArrayList<String> dependencies = new ArrayList<String>();
                CopyOnWriteArrayList<TableView> dependentViews = this.table.getDependentViews();
                if (dependentViews != null && !dependentViews.isEmpty()) {
                    for (TableView v : dependentViews) {
                        dependencies.add(v.getName());
                    }
                }
                if (this.session.getDatabase().getSettings().standardDropTableRestrict && (constraints = this.table.getConstraints()) != null && !constraints.isEmpty()) {
                    for (Constraint c : constraints) {
                        if (c.getTable() == this.table) continue;
                        dependencies.add(c.getName());
                    }
                }
                if (!dependencies.isEmpty()) {
                    throw DbException.get(90107, this.tableName, StringUtils.join(new StringBuilder(), dependencies, ", ").toString());
                }
            }
            this.table.lock(this.session, true, true);
        }
        if (this.next != null) {
            this.next.prepareDrop();
        }
    }

    private void executeDrop() {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table != null) {
            this.table.setModified();
            Database db = this.session.getDatabase();
            db.lockMeta(this.session);
            db.removeSchemaObject(this.session, this.table);
        }
        if (this.next != null) {
            this.next.executeDrop();
        }
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.prepareDrop();
        this.executeDrop();
        return 0;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
        if (this.next != null) {
            this.next.setDropAction(dropAction);
        }
    }

    @Override
    public int getType() {
        return 44;
    }
}

